/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.sanitizepdf;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.choices.ChoicesProvider;

final class SanitizePDFNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Remove Java Script", description="Remove JavaScript actions from the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_Java_ScriptPersistor.class)
    String removeJavaScript = "true";
    @Widget(title="Remove Embedded Files", description="Remove embedded files from the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_Embedded_FilesPersistor.class)
    String removeEmbeddedFiles = "true";
    @Widget(title="Remove XMP Metadata", description="Remove XMP metadata from the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_XMP_MetadataPersistor.class)
    String removeXMPMetadata = "false";
    @Widget(title="Remove Metadata", description="Remove document info metadata from the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_MetadataPersistor.class)
    String removeMetadata = "false";
    @Widget(title="Remove Links", description="Remove links from the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_LinksPersistor.class)
    String removeLinks = "false";
    @Widget(title="Remove Fonts", description="Remove fonts from the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_FontsPersistor.class)
    String removeFonts = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=SanitizePDFNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    SanitizePDFNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/security/sanitize-pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeJavaScript", this.removeJavaScript));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeEmbeddedFiles", this.removeEmbeddedFiles));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeXMPMetadata", this.removeXMPMetadata));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeMetadata", this.removeMetadata));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeLinks", this.removeLinks));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeFonts", this.removeFonts));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class Remove_Embedded_FilesPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeEmbeddedFiles";

        private Remove_Embedded_FilesPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Remove_FontsPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeFonts";

        private Remove_FontsPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Remove_Java_ScriptPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeJavaScript";

        private Remove_Java_ScriptPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Remove_LinksPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeLinks";

        private Remove_LinksPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Remove_MetadataPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeMetadata";

        private Remove_MetadataPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Remove_XMP_MetadataPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeXMPMetadata";

        private Remove_XMP_MetadataPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class SanitizePDFNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private SanitizePDFNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

