/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.scannereffect;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class ScannerEffectNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Quality", description="Scan quality preset\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=QualityChoicesProvider.class)
    String quality = QUALITY_VALUES[0];
    private static final String[] QUALITY_VALUES = new String[]{"low", "medium", "high"};
    @Widget(title="Rotation", description="Rotation preset\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=RotationChoicesProvider.class)
    String rotation = ROTATION_VALUES[0];
    private static final String[] ROTATION_VALUES = new String[]{"none", "slight", "moderate", "severe"};
    @Widget(title="Set Colorspace", description="Enable to set the optional field <b>Colorspace</b>")
    @ValueReference(value=ColorspaceEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean colorspaceEnabled = false;
    @Widget(title="Colorspace", description="Colorspace for output image\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ColorspaceEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=ColorspaceChoicesProvider.class)
    String colorspace = COLORSPACE_VALUES[0];
    private static final String[] COLORSPACE_VALUES = new String[]{"grayscale", "color"};
    @Widget(title="Set Border", description="Enable to set the optional field <b>Border</b>")
    @ValueReference(value=BorderEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean borderEnabled = false;
    @Widget(title="Border", description="Border thickness in pixels\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BorderEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int border = 0;
    @Widget(title="Set Rotate", description="Enable to set the optional field <b>Rotate</b>")
    @ValueReference(value=RotateEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean rotateEnabled = false;
    @Widget(title="Rotate", description="Base rotation in degrees\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RotateEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int rotate = 0;
    @Widget(title="Set Rotate Variance", description="Enable to set the optional field <b>Rotate Variance</b>")
    @ValueReference(value=RotateVarianceEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean rotateVarianceEnabled = false;
    @Widget(title="Rotate Variance", description="Random rotation variance in degrees\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RotateVarianceEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int rotateVariance = 0;
    @Widget(title="Set Brightness", description="Enable to set the optional field <b>Brightness</b>")
    @ValueReference(value=BrightnessEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean brightnessEnabled = false;
    @Widget(title="Brightness", description="Brightness multiplier (1.0 = no change)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BrightnessEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double brightness = 0.0;
    @Widget(title="Set Contrast", description="Enable to set the optional field <b>Contrast</b>")
    @ValueReference(value=ContrastEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean contrastEnabled = false;
    @Widget(title="Contrast", description="Contrast multiplier (1.0 = no change)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ContrastEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double contrast = 0.0;
    @Widget(title="Set Blur", description="Enable to set the optional field <b>Blur</b>")
    @ValueReference(value=BlurEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean blurEnabled = false;
    @Widget(title="Blur", description="Blur amount (0 = none, higher = more blur)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BlurEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double blur = 0.0;
    @Widget(title="Set Noise", description="Enable to set the optional field <b>Noise</b>")
    @ValueReference(value=NoiseEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean noiseEnabled = false;
    @Widget(title="Noise", description="Noise amount (0 = none, higher = more noise)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NoiseEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double noise = 0.0;
    @Widget(title="Set Yellowish", description="Enable to set the optional field <b>Yellowish</b>")
    @ValueReference(value=YellowishEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean yellowishEnabled = false;
    @Widget(title="Yellowish", description="Simulate yellowed paper\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=YellowishEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=YellowishPersistor.class)
    String yellowish = "false";
    @Widget(title="Set Resolution", description="Enable to set the optional field <b>Resolution</b>")
    @ValueReference(value=ResolutionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean resolutionEnabled = false;
    @Widget(title="Resolution", description="Rendering resolution in DPI\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ResolutionEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int resolution = 0;
    @Widget(title="Set Advanced Enabled", description="Enable to set the optional field <b>Advanced Enabled</b>")
    @ValueReference(value=AdvancedEnabledEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean advancedEnabledEnabled = false;
    @Widget(title="Advanced Enabled", description="Whether advanced settings are enabled\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AdvancedEnabledEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Advanced_EnabledPersistor.class)
    String advancedEnabled = "false";
    @Widget(title="Set Rotation Value", description="Enable to set the optional field <b>Rotation Value</b>")
    @ValueReference(value=RotationValueEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean rotationValueEnabled = false;
    @Widget(title="Rotation Value", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RotationValueEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int rotationValue = 0;
    @Widget(title="Set Quality Value", description="Enable to set the optional field <b>Quality Value</b>")
    @ValueReference(value=QualityValueEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean qualityValueEnabled = false;
    @Widget(title="Quality Value", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=QualityValueEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int qualityValue = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ScannerEffectNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ScannerEffectNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.quality == null || this.quality.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cQuality\u201d is required.");
        }
        if (this.rotation == null || this.rotation.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRotation\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/scanner-effect");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "quality", this.quality));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "rotation", this.rotation));
        if (this.colorspaceEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "colorspace", this.colorspace));
        }
        if (this.borderEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "border", this.border));
        }
        if (this.rotateEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "rotate", this.rotate));
        }
        if (this.rotateVarianceEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "rotateVariance", this.rotateVariance));
        }
        if (this.brightnessEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "brightness", this.brightness));
        }
        if (this.contrastEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "contrast", this.contrast));
        }
        if (this.blurEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "blur", this.blur));
        }
        if (this.noiseEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "noise", this.noise));
        }
        if (this.yellowishEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "yellowish", this.yellowish));
        }
        if (this.resolutionEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "resolution", this.resolution));
        }
        if (this.advancedEnabledEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "advancedEnabled", this.advancedEnabled));
        }
        if (this.rotationValueEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "rotationValue", this.rotationValue));
        }
        if (this.qualityValueEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "qualityValue", this.qualityValue));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AdvancedEnabledEnabledRef
    implements BooleanReference {
        private AdvancedEnabledEnabledRef() {
        }
    }

    private static final class Advanced_EnabledPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "advancedEnabled";

        private Advanced_EnabledPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class BlurEnabledRef
    implements BooleanReference {
        private BlurEnabledRef() {
        }
    }

    private static final class BorderEnabledRef
    implements BooleanReference {
        private BorderEnabledRef() {
        }
    }

    private static final class BrightnessEnabledRef
    implements BooleanReference {
        private BrightnessEnabledRef() {
        }
    }

    private static final class ColorspaceChoicesProvider
    implements StringChoicesProvider {
        private ColorspaceChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(COLORSPACE_VALUES);
        }
    }

    private static final class ColorspaceEnabledRef
    implements BooleanReference {
        private ColorspaceEnabledRef() {
        }
    }

    private static final class ContrastEnabledRef
    implements BooleanReference {
        private ContrastEnabledRef() {
        }
    }

    private static final class NoiseEnabledRef
    implements BooleanReference {
        private NoiseEnabledRef() {
        }
    }

    private static final class QualityChoicesProvider
    implements StringChoicesProvider {
        private QualityChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(QUALITY_VALUES);
        }
    }

    private static final class QualityValueEnabledRef
    implements BooleanReference {
        private QualityValueEnabledRef() {
        }
    }

    private static final class ResolutionEnabledRef
    implements BooleanReference {
        private ResolutionEnabledRef() {
        }
    }

    private static final class RotateEnabledRef
    implements BooleanReference {
        private RotateEnabledRef() {
        }
    }

    private static final class RotateVarianceEnabledRef
    implements BooleanReference {
        private RotateVarianceEnabledRef() {
        }
    }

    private static final class RotationChoicesProvider
    implements StringChoicesProvider {
        private RotationChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ROTATION_VALUES);
        }
    }

    private static final class RotationValueEnabledRef
    implements BooleanReference {
        private RotationValueEnabledRef() {
        }
    }

    private static final class ScannerEffectNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ScannerEffectNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class YellowishEnabledRef
    implements BooleanReference {
        private YellowishEnabledRef() {
        }
    }

    private static final class YellowishPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "yellowish";

        private YellowishPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }
}

