/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.signpdfwithcert;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class SignPDFWithCertNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Cert Type", description="The type of the digital certificate\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Cert_TypeChoicesProvider.class)
    String certType = CERT_TYPE_VALUES[0];
    private static final String[] CERT_TYPE_VALUES = new String[]{"PEM", "PKCS12", "PFX", "JKS", "SERVER"};
    @Widget(title="Set Private Key File", description="Enable to set the optional field <b>Private Key File</b>")
    @ValueReference(value=PrivateKeyFileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean privateKeyFileEnabled = false;
    @Widget(title="Private Key File", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PrivateKeyFileEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String privateKeyFile = "";
    @Widget(title="Set Cert File", description="Enable to set the optional field <b>Cert File</b>")
    @ValueReference(value=CertFileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean certFileEnabled = false;
    @Widget(title="Cert File", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CertFileEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String certFile = "";
    @Widget(title="Set P12file", description="Enable to set the optional field <b>P12file</b>")
    @ValueReference(value=P12FileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean p12FileEnabled = false;
    @Widget(title="P12file", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=P12FileEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String p12File = "";
    @Widget(title="Set Jks File", description="Enable to set the optional field <b>Jks File</b>")
    @ValueReference(value=JksFileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean jksFileEnabled = false;
    @Widget(title="Jks File", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=JksFileEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String jksFile = "";
    @Widget(title="Set Password", description="Enable to set the optional field <b>Password</b>")
    @ValueReference(value=PasswordEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean passwordEnabled = false;
    @Widget(title="Password", description="The password for the keystore or the private key\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PasswordEnabledRef.class, type=Effect.EffectType.SHOW)
    String password = null;
    @Widget(title="Show Signature", description="Whether to visually show the signature in the PDF file\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Show_SignaturePersistor.class)
    String showSignature = "false";
    @Widget(title="Set Reason", description="Enable to set the optional field <b>Reason</b>")
    @ValueReference(value=ReasonEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean reasonEnabled = false;
    @Widget(title="Reason", description="The reason for signing the PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ReasonEnabledRef.class, type=Effect.EffectType.SHOW)
    String reason = "Signed by SPDF";
    @Widget(title="Set Location", description="Enable to set the optional field <b>Location</b>")
    @ValueReference(value=LocationEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean locationEnabled = false;
    @Widget(title="Location", description="The location where the PDF is signed\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LocationEnabledRef.class, type=Effect.EffectType.SHOW)
    String location = "SPDF";
    @Widget(title="Set Name", description="Enable to set the optional field <b>Name</b>")
    @ValueReference(value=NameEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nameEnabled = false;
    @Widget(title="Name", description="The name of the signer\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NameEnabledRef.class, type=Effect.EffectType.SHOW)
    String name = "SPDF";
    @Widget(title="Set Page Number", description="Enable to set the optional field <b>Page Number</b>")
    @ValueReference(value=PageNumberEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageNumberEnabled = false;
    @Widget(title="Page Number", description="The page number where the signature should be visible. This is required if showSignature is set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageNumberEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int pageNumber = 1;
    @Widget(title="Show Logo", description="Whether to visually show a signature logo along with the signature\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Show_LogoPersistor.class)
    String showLogo = "true";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=SignPDFWithCertNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    SignPDFWithCertNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.certType == null || this.certType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cCert Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/security/cert-sign");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "certType", this.certType));
        if (this.privateKeyFileEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "privateKeyFile", new HttpRequestNodeParameters.File(this.privateKeyFile)));
        }
        if (this.certFileEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "certFile", new HttpRequestNodeParameters.File(this.certFile)));
        }
        if (this.p12FileEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "p12File", new HttpRequestNodeParameters.File(this.p12File)));
        }
        if (this.jksFileEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "jksFile", new HttpRequestNodeParameters.File(this.jksFile)));
        }
        if (this.passwordEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "password", this.password));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "showSignature", this.showSignature));
        if (this.reasonEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "reason", this.reason));
        }
        if (this.locationEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "location", this.location));
        }
        if (this.nameEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "name", this.name));
        }
        if (this.pageNumberEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "pageNumber", this.pageNumber));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "showLogo", this.showLogo));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class CertFileEnabledRef
    implements BooleanReference {
        private CertFileEnabledRef() {
        }
    }

    private static final class Cert_TypeChoicesProvider
    implements StringChoicesProvider {
        private Cert_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(CERT_TYPE_VALUES);
        }
    }

    private static final class JksFileEnabledRef
    implements BooleanReference {
        private JksFileEnabledRef() {
        }
    }

    private static final class LocationEnabledRef
    implements BooleanReference {
        private LocationEnabledRef() {
        }
    }

    private static final class NameEnabledRef
    implements BooleanReference {
        private NameEnabledRef() {
        }
    }

    private static final class P12FileEnabledRef
    implements BooleanReference {
        private P12FileEnabledRef() {
        }
    }

    private static final class PageNumberEnabledRef
    implements BooleanReference {
        private PageNumberEnabledRef() {
        }
    }

    private static final class PasswordEnabledRef
    implements BooleanReference {
        private PasswordEnabledRef() {
        }
    }

    private static final class PrivateKeyFileEnabledRef
    implements BooleanReference {
        private PrivateKeyFileEnabledRef() {
        }
    }

    private static final class ReasonEnabledRef
    implements BooleanReference {
        private ReasonEnabledRef() {
        }
    }

    private static final class Show_LogoPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "showLogo";

        private Show_LogoPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Show_SignaturePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "showSignature";

        private Show_SignaturePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class SignPDFWithCertNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private SignPDFWithCertNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

