/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.server;

import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParameters;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

class ServerNodeParameters
implements NodeParameters {
    private static final String[] SERVER_VALUES = new String[]{"{serverURL}"};
    private static final String SERVER_DEFAULT_VALUE = SERVER_VALUES[0];
    @Widget(title="Server", description="Select the server endpoint to use. The following endpoints are available:\n<ul>\n\t<li><tt>{serverURL}</tt></li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=ServerChoicesProvider.class)
    String server = SERVER_DEFAULT_VALUE;
    private static final String SERVER_URL_DEFAULT_VALUE = "https://api.stirling.com";
    @Widget(title="Server URL", description="")
    @Migrate(loadDefaultIfAbsent=true)
    String serverURL = "https://api.stirling.com";

    ServerNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.server.contains("{serverURL}") && (this.serverURL == null || this.serverURL.isEmpty())) {
            throw new InvalidSettingsException("Value for \u201cServer URL\u201d is required.");
        }
    }

    private static final class ServerChoicesProvider
    implements StringChoicesProvider {
        private ServerChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.stream(SERVER_VALUES).toList();
        }
    }
}

