/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class ArrayInput
extends JPanel {
    private Function<ArrayInput, ? extends ArrayInputRow<?>> rowFactory;

    private ArrayInput(Function<ArrayInput, ? extends ArrayInputRow<?>> rowFactory) {
        this.setLayout(new GridLayout(0, 1));
        this.rowFactory = rowFactory;
        this.add(this.createInputRow());
    }

    public static ArrayInput textFields() {
        return new ArrayInput(input -> new TextFieldArrayInputRow((ArrayInput)input));
    }

    public static ArrayInput comboBoxes(String[] values) {
        return new ArrayInput(input -> new ComboBoxArrayInputRow((ArrayInput)input, values));
    }

    public static ArrayInput filePickers() {
        return new ArrayInput(input -> new FilePickerArrayInputRow((ArrayInput)input));
    }

    private void addRowAfter(ArrayInputRow<?> arrayInputRow) {
        int index = Arrays.asList(this.getComponents()).indexOf(arrayInputRow) + 1;
        this.add((Component)this.createInputRow(), index);
        this.enableDisableRemoveButton();
        this.revalidate();
    }

    private void removeRow(ArrayInputRow<?> arrayInputRow) {
        this.remove(arrayInputRow);
        this.enableDisableRemoveButton();
        this.revalidate();
    }

    private void enableDisableRemoveButton() {
        boolean canRemove = this.getComponentCount() > 1;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            ArrayInputRow row = (ArrayInputRow)component;
            row.removeButton.setEnabled(canRemove);
            ++n2;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setEnabled(enabled);
            ++n2;
        }
        this.enableDisableRemoveButton();
    }

    public final String[] getValues() {
        String[] values = new String[this.getComponents().length];
        int i = 0;
        while (i < this.getComponentCount()) {
            Component component = this.getComponent(i);
            ArrayInputRow row = (ArrayInputRow)component;
            values[i] = row.getValue();
            ++i;
        }
        return values;
    }

    public final void setValues(String[] values) {
        this.removeAll();
        int i = 0;
        while (i < values.length) {
            ArrayInputRow<?> row = this.createInputRow();
            row.setValue(values[i]);
            this.add((Component)row, i);
            ++i;
        }
        this.enableDisableRemoveButton();
    }

    private final ArrayInputRow<?> createInputRow() {
        return this.rowFactory.apply(this);
    }

    private static abstract class ArrayInputRow<C extends JComponent>
    extends JPanel {
        protected final C component;
        private final JButton removeButton;
        private final JButton addButton;

        ArrayInputRow(ArrayInput parent, C component) {
            this.component = component;
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            this.add((Component)component, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.removeButton = new JButton("\u2013");
            Dimension removeButtonSize = this.removeButton.getPreferredSize();
            removeButtonSize.width = 40;
            this.removeButton.setPreferredSize(removeButtonSize);
            this.removeButton.addActionListener(e -> parent.removeRow(this));
            this.add((Component)this.removeButton, c);
            ++c.gridx;
            this.addButton = new JButton("+");
            Dimension addButtonSize = this.addButton.getPreferredSize();
            addButtonSize.width = 40;
            this.addButton.setPreferredSize(addButtonSize);
            this.addButton.addActionListener(e -> parent.addRowAfter(this));
            this.add((Component)this.addButton, c);
        }

        @Override
        public final void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            ((JComponent)this.component).setEnabled(enabled);
            this.removeButton.setEnabled(enabled);
            this.addButton.setEnabled(enabled);
        }

        abstract String getValue();

        abstract void setValue(String var1);
    }

    private static final class ComboBoxArrayInputRow
    extends ArrayInputRow<JComboBox<String>> {
        ComboBoxArrayInputRow(ArrayInput parent, String[] values) {
            super(parent, new JComboBox<String>(values));
        }

        @Override
        String getValue() {
            return (String)((JComboBox)this.component).getSelectedItem();
        }

        @Override
        void setValue(String value) {
            ((JComboBox)this.component).setSelectedItem(value);
        }
    }

    private static final class FilePickerArrayInputRow
    extends ArrayInputRow<FilePicker> {
        FilePickerArrayInputRow(ArrayInput parent) {
            super(parent, new FilePicker());
        }

        @Override
        String getValue() {
            return ((FilePicker)this.component).getFile();
        }

        @Override
        void setValue(String value) {
            ((FilePicker)this.component).setFile(value);
        }
    }

    private static final class TextFieldArrayInputRow
    extends ArrayInputRow<JTextField> {
        TextFieldArrayInputRow(ArrayInput parent) {
            super(parent, new JTextField(15));
        }

        @Override
        String getValue() {
            return ((JTextField)this.component).getText();
        }

        @Override
        void setValue(String value) {
            ((JTextField)this.component).setText(value);
        }
    }
}

