/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.containstext;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ContainsTextNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String PAGE_NUMBERS_KEY = "pageNumbers";
    private static final String PAGE_NUMBERS_DEFAULT_VALUE = "all";
    private String pageNumbers = "all";
    private static final String PAGE_NUMBERS_ENABLED_KEY = "pageNumbersEnabled";
    private boolean pageNumbersEnabled = false;
    private static final String TEXT_KEY = "text";
    private static final String TEXT_DEFAULT_VALUE = null;
    private String text = TEXT_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ContainsTextNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(PAGE_NUMBERS_KEY, this.pageNumbers);
        settings.addBoolean(PAGE_NUMBERS_ENABLED_KEY, this.pageNumbersEnabled);
        settings.addString(TEXT_KEY, this.text);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.pageNumbers = settings.getString(PAGE_NUMBERS_KEY, PAGE_NUMBERS_DEFAULT_VALUE);
        this.pageNumbersEnabled = settings.getBoolean(PAGE_NUMBERS_ENABLED_KEY, false);
        this.text = settings.getString(TEXT_KEY, TEXT_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cText\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String pageNumbers() {
        return this.pageNumbers;
    }

    void pageNumbers(String value) {
        this.pageNumbers = value;
    }

    boolean pageNumbersEnabled() {
        return this.pageNumbersEnabled;
    }

    void pageNumbersEnabled(boolean value) {
        this.pageNumbersEnabled = value;
    }

    String text() {
        return this.text;
    }

    void text(String value) {
        this.text = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

