/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.converttoimage;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ConvertToImageNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    static final String[] IMAGE_FORMAT_VALUES = new String[]{"png", "jpeg", "jpg", "gif", "webp"};
    private static final String IMAGE_FORMAT_KEY = "imageFormat";
    private static final String IMAGE_FORMAT_DEFAULT_VALUE = IMAGE_FORMAT_VALUES[0];
    private String imageFormat = IMAGE_FORMAT_DEFAULT_VALUE;
    private static final String IMAGE_FORMAT_ENABLED_KEY = "imageFormatEnabled";
    private boolean imageFormatEnabled = false;
    static final String[] SINGLE_OR_MULTIPLE_VALUES = new String[]{"single", "multiple"};
    private static final String SINGLE_OR_MULTIPLE_KEY = "singleOrMultiple";
    private static final String SINGLE_OR_MULTIPLE_DEFAULT_VALUE = SINGLE_OR_MULTIPLE_VALUES[0];
    private String singleOrMultiple = SINGLE_OR_MULTIPLE_DEFAULT_VALUE;
    private static final String SINGLE_OR_MULTIPLE_ENABLED_KEY = "singleOrMultipleEnabled";
    private boolean singleOrMultipleEnabled = false;
    private static final String PAGE_NUMBERS_KEY = "pageNumbers";
    private static final String PAGE_NUMBERS_DEFAULT_VALUE = null;
    private String pageNumbers = PAGE_NUMBERS_DEFAULT_VALUE;
    private static final String PAGE_NUMBERS_ENABLED_KEY = "pageNumbersEnabled";
    private boolean pageNumbersEnabled = false;
    static final String[] COLOR_TYPE_VALUES = new String[]{"color", "greyscale", "blackwhite"};
    private static final String COLOR_TYPE_KEY = "colorType";
    private static final String COLOR_TYPE_DEFAULT_VALUE = COLOR_TYPE_VALUES[0];
    private String colorType = COLOR_TYPE_DEFAULT_VALUE;
    private static final String COLOR_TYPE_ENABLED_KEY = "colorTypeEnabled";
    private boolean colorTypeEnabled = false;
    private static final String DPI_KEY = "dpi";
    private static final String DPI_DEFAULT_VALUE = null;
    private String dpi = DPI_DEFAULT_VALUE;
    private static final String DPI_ENABLED_KEY = "dpiEnabled";
    private boolean dpiEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ConvertToImageNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(IMAGE_FORMAT_KEY, this.imageFormat);
        settings.addBoolean(IMAGE_FORMAT_ENABLED_KEY, this.imageFormatEnabled);
        settings.addString(SINGLE_OR_MULTIPLE_KEY, this.singleOrMultiple);
        settings.addBoolean(SINGLE_OR_MULTIPLE_ENABLED_KEY, this.singleOrMultipleEnabled);
        settings.addString(PAGE_NUMBERS_KEY, this.pageNumbers);
        settings.addBoolean(PAGE_NUMBERS_ENABLED_KEY, this.pageNumbersEnabled);
        settings.addString(COLOR_TYPE_KEY, this.colorType);
        settings.addBoolean(COLOR_TYPE_ENABLED_KEY, this.colorTypeEnabled);
        settings.addString(DPI_KEY, this.dpi);
        settings.addBoolean(DPI_ENABLED_KEY, this.dpiEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.imageFormat = settings.getString(IMAGE_FORMAT_KEY, IMAGE_FORMAT_DEFAULT_VALUE);
        this.imageFormatEnabled = settings.getBoolean(IMAGE_FORMAT_ENABLED_KEY, false);
        this.singleOrMultiple = settings.getString(SINGLE_OR_MULTIPLE_KEY, SINGLE_OR_MULTIPLE_DEFAULT_VALUE);
        this.singleOrMultipleEnabled = settings.getBoolean(SINGLE_OR_MULTIPLE_ENABLED_KEY, false);
        this.pageNumbers = settings.getString(PAGE_NUMBERS_KEY, PAGE_NUMBERS_DEFAULT_VALUE);
        this.pageNumbersEnabled = settings.getBoolean(PAGE_NUMBERS_ENABLED_KEY, false);
        this.colorType = settings.getString(COLOR_TYPE_KEY, COLOR_TYPE_DEFAULT_VALUE);
        this.colorTypeEnabled = settings.getBoolean(COLOR_TYPE_ENABLED_KEY, false);
        this.dpi = settings.getString(DPI_KEY, DPI_DEFAULT_VALUE);
        this.dpiEnabled = settings.getBoolean(DPI_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String imageFormat() {
        return this.imageFormat;
    }

    void imageFormat(String value) {
        this.imageFormat = value;
    }

    boolean imageFormatEnabled() {
        return this.imageFormatEnabled;
    }

    void imageFormatEnabled(boolean value) {
        this.imageFormatEnabled = value;
    }

    String singleOrMultiple() {
        return this.singleOrMultiple;
    }

    void singleOrMultiple(String value) {
        this.singleOrMultiple = value;
    }

    boolean singleOrMultipleEnabled() {
        return this.singleOrMultipleEnabled;
    }

    void singleOrMultipleEnabled(boolean value) {
        this.singleOrMultipleEnabled = value;
    }

    String pageNumbers() {
        return this.pageNumbers;
    }

    void pageNumbers(String value) {
        this.pageNumbers = value;
    }

    boolean pageNumbersEnabled() {
        return this.pageNumbersEnabled;
    }

    void pageNumbersEnabled(boolean value) {
        this.pageNumbersEnabled = value;
    }

    String colorType() {
        return this.colorType;
    }

    void colorType(String value) {
        this.colorType = value;
    }

    boolean colorTypeEnabled() {
        return this.colorTypeEnabled;
    }

    void colorTypeEnabled(boolean value) {
        this.colorTypeEnabled = value;
    }

    String dpi() {
        return this.dpi;
    }

    void dpi(String value) {
        this.dpi = value;
    }

    boolean dpiEnabled() {
        return this.dpiEnabled;
    }

    void dpiEnabled(boolean value) {
        this.dpiEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

