/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.extractimages;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ExtractImagesNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    static final String[] FORMAT_VALUES = new String[]{"png", "jpeg", "gif"};
    private static final String FORMAT_KEY = "format";
    private static final String FORMAT_DEFAULT_VALUE = FORMAT_VALUES[0];
    private String format = FORMAT_DEFAULT_VALUE;
    private static final String FORMAT_ENABLED_KEY = "formatEnabled";
    private boolean formatEnabled = false;
    private static final String ALLOW_DUPLICATES_KEY = "allowDuplicates";
    private static final boolean ALLOW_DUPLICATES_DEFAULT_VALUE = false;
    private boolean allowDuplicates = false;
    private static final String ALLOW_DUPLICATES_ENABLED_KEY = "allowDuplicatesEnabled";
    private boolean allowDuplicatesEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ExtractImagesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(FORMAT_KEY, this.format);
        settings.addBoolean(FORMAT_ENABLED_KEY, this.formatEnabled);
        settings.addBoolean(ALLOW_DUPLICATES_KEY, this.allowDuplicates);
        settings.addBoolean(ALLOW_DUPLICATES_ENABLED_KEY, this.allowDuplicatesEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.format = settings.getString(FORMAT_KEY, FORMAT_DEFAULT_VALUE);
        this.formatEnabled = settings.getBoolean(FORMAT_ENABLED_KEY, false);
        this.allowDuplicates = settings.getBoolean(ALLOW_DUPLICATES_KEY, false);
        this.allowDuplicatesEnabled = settings.getBoolean(ALLOW_DUPLICATES_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String format() {
        return this.format;
    }

    void format(String value) {
        this.format = value;
    }

    boolean formatEnabled() {
        return this.formatEnabled;
    }

    void formatEnabled(boolean value) {
        this.formatEnabled = value;
    }

    boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    void allowDuplicates(boolean value) {
        this.allowDuplicates = value;
    }

    boolean allowDuplicatesEnabled() {
        return this.allowDuplicatesEnabled;
    }

    void allowDuplicatesEnabled(boolean value) {
        this.allowDuplicatesEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

