/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.extractimagescans;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.extractimagescans.ExtractImageScansNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ExtractImageScansNodeDialog
extends NodeDialogPane {
    private final ExtractImageScansNodeSettings nodeSettings = new ExtractImageScansNodeSettings();
    private FilePicker fileInput;
    private JSpinner angleThreshold;
    private JCheckBox angleThresholdEnabled;
    private JSpinner tolerance;
    private JCheckBox toleranceEnabled;
    private JSpinner minArea;
    private JCheckBox minAreaEnabled;
    private JSpinner minContourArea;
    private JCheckBox minContourAreaEnabled;
    private JSpinner borderSize;
    private JCheckBox borderSizeEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ExtractImageScansNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Angle Threshold:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.angleThresholdEnabled = new JCheckBox();
        this.angleThresholdEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.angleThresholdEnabled.setSelected(!this.angleThresholdEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.angleThresholdEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.angleThreshold = new JSpinner(new SpinnerNumberModel(ExtractImageScansNodeSettings.ANGLE_THRESHOLD_DEFAULT_VALUE, ExtractImageScansNodeSettings.ANGLE_THRESHOLD_MINIMUM_VALUE, ExtractImageScansNodeSettings.ANGLE_THRESHOLD_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.angleThreshold, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Tolerance:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.toleranceEnabled = new JCheckBox();
        this.toleranceEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.toleranceEnabled.setSelected(!this.toleranceEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.toleranceEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.tolerance = new JSpinner(new SpinnerNumberModel(ExtractImageScansNodeSettings.TOLERANCE_DEFAULT_VALUE, ExtractImageScansNodeSettings.TOLERANCE_MINIMUM_VALUE, ExtractImageScansNodeSettings.TOLERANCE_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.tolerance, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Min Area:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.minAreaEnabled = new JCheckBox();
        this.minAreaEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.minAreaEnabled.setSelected(!this.minAreaEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.minAreaEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.minArea = new JSpinner(new SpinnerNumberModel(ExtractImageScansNodeSettings.MIN_AREA_DEFAULT_VALUE, ExtractImageScansNodeSettings.MIN_AREA_MINIMUM_VALUE, ExtractImageScansNodeSettings.MIN_AREA_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.minArea, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Min Contour Area:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.minContourAreaEnabled = new JCheckBox();
        this.minContourAreaEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.minContourAreaEnabled.setSelected(!this.minContourAreaEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.minContourAreaEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.minContourArea = new JSpinner(new SpinnerNumberModel(ExtractImageScansNodeSettings.MIN_CONTOUR_AREA_DEFAULT_VALUE, ExtractImageScansNodeSettings.MIN_CONTOUR_AREA_MINIMUM_VALUE, ExtractImageScansNodeSettings.MIN_CONTOUR_AREA_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.minContourArea, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Border Size:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        this.borderSizeEnabled = new JCheckBox();
        this.borderSizeEnabled.addActionListener(e -> this.updateComponents());
        label5.addActionListener(e -> {
            this.borderSizeEnabled.setSelected(!this.borderSizeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.borderSizeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.borderSize = new JSpinner(new SpinnerNumberModel(ExtractImageScansNodeSettings.BORDER_SIZE_DEFAULT_VALUE, ExtractImageScansNodeSettings.BORDER_SIZE_MINIMUM_VALUE, ExtractImageScansNodeSettings.BORDER_SIZE_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.borderSize, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ExtractImageScansNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.angleThreshold.setEnabled(this.angleThresholdEnabled.isSelected());
        this.tolerance.setEnabled(this.toleranceEnabled.isSelected());
        this.minArea.setEnabled(this.minAreaEnabled.isSelected());
        this.minContourArea.setEnabled(this.minContourAreaEnabled.isSelected());
        this.borderSize.setEnabled(this.borderSizeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.angleThreshold((Integer)this.angleThreshold.getValue());
        this.nodeSettings.angleThresholdEnabled(this.angleThresholdEnabled.isSelected());
        this.nodeSettings.tolerance((Integer)this.tolerance.getValue());
        this.nodeSettings.toleranceEnabled(this.toleranceEnabled.isSelected());
        this.nodeSettings.minArea((Integer)this.minArea.getValue());
        this.nodeSettings.minAreaEnabled(this.minAreaEnabled.isSelected());
        this.nodeSettings.minContourArea((Integer)this.minContourArea.getValue());
        this.nodeSettings.minContourAreaEnabled(this.minContourAreaEnabled.isSelected());
        this.nodeSettings.borderSize((Integer)this.borderSize.getValue());
        this.nodeSettings.borderSizeEnabled(this.borderSizeEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.angleThreshold.setValue(this.nodeSettings.angleThreshold());
        this.angleThresholdEnabled.setSelected(this.nodeSettings.angleThresholdEnabled());
        this.tolerance.setValue(this.nodeSettings.tolerance());
        this.toleranceEnabled.setSelected(this.nodeSettings.toleranceEnabled());
        this.minArea.setValue(this.nodeSettings.minArea());
        this.minAreaEnabled.setSelected(this.nodeSettings.minAreaEnabled());
        this.minContourArea.setValue(this.nodeSettings.minContourArea());
        this.minContourAreaEnabled.setSelected(this.nodeSettings.minContourAreaEnabled());
        this.borderSize.setValue(this.nodeSettings.borderSize());
        this.borderSizeEnabled.setSelected(this.nodeSettings.borderSizeEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

