/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.flatten;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class FlattenNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String FLATTEN_ONLY_FORMS_KEY = "flattenOnlyForms";
    private static final boolean FLATTEN_ONLY_FORMS_DEFAULT_VALUE = false;
    private boolean flattenOnlyForms = false;
    private static final String FLATTEN_ONLY_FORMS_ENABLED_KEY = "flattenOnlyFormsEnabled";
    private boolean flattenOnlyFormsEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    FlattenNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addBoolean(FLATTEN_ONLY_FORMS_KEY, this.flattenOnlyForms);
        settings.addBoolean(FLATTEN_ONLY_FORMS_ENABLED_KEY, this.flattenOnlyFormsEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.flattenOnlyForms = settings.getBoolean(FLATTEN_ONLY_FORMS_KEY, false);
        this.flattenOnlyFormsEnabled = settings.getBoolean(FLATTEN_ONLY_FORMS_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    boolean flattenOnlyForms() {
        return this.flattenOnlyForms;
    }

    void flattenOnlyForms(boolean value) {
        this.flattenOnlyForms = value;
    }

    boolean flattenOnlyFormsEnabled() {
        return this.flattenOnlyFormsEnabled;
    }

    void flattenOnlyFormsEnabled(boolean value) {
        this.flattenOnlyFormsEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

