/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.mergemultiplepagesintoone;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class MergeMultiplePagesIntoOneNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String PAGES_PER_SHEET_KEY = "pagesPerSheet";
    static final Integer PAGES_PER_SHEET_DEFAULT_VALUE = 0;
    static final Integer PAGES_PER_SHEET_MINIMUM_VALUE = null;
    static final Integer PAGES_PER_SHEET_MAXIMUM_VALUE = null;
    private int pagesPerSheet = PAGES_PER_SHEET_DEFAULT_VALUE;
    private static final String PAGES_PER_SHEET_ENABLED_KEY = "pagesPerSheetEnabled";
    private boolean pagesPerSheetEnabled = false;
    private static final String ADD_BORDER_KEY = "addBorder";
    private static final boolean ADD_BORDER_DEFAULT_VALUE = false;
    private boolean addBorder = false;
    private static final String ADD_BORDER_ENABLED_KEY = "addBorderEnabled";
    private boolean addBorderEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    MergeMultiplePagesIntoOneNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addInt(PAGES_PER_SHEET_KEY, this.pagesPerSheet);
        settings.addBoolean(PAGES_PER_SHEET_ENABLED_KEY, this.pagesPerSheetEnabled);
        settings.addBoolean(ADD_BORDER_KEY, this.addBorder);
        settings.addBoolean(ADD_BORDER_ENABLED_KEY, this.addBorderEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.pagesPerSheet = settings.getInt(PAGES_PER_SHEET_KEY, PAGES_PER_SHEET_DEFAULT_VALUE.intValue());
        this.pagesPerSheetEnabled = settings.getBoolean(PAGES_PER_SHEET_ENABLED_KEY, false);
        this.addBorder = settings.getBoolean(ADD_BORDER_KEY, false);
        this.addBorderEnabled = settings.getBoolean(ADD_BORDER_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    int pagesPerSheet() {
        return this.pagesPerSheet;
    }

    void pagesPerSheet(int value) {
        this.pagesPerSheet = value;
    }

    boolean pagesPerSheetEnabled() {
        return this.pagesPerSheetEnabled;
    }

    void pagesPerSheetEnabled(boolean value) {
        this.pagesPerSheetEnabled = value;
    }

    boolean addBorder() {
        return this.addBorder;
    }

    void addBorder(boolean value) {
        this.addBorder = value;
    }

    boolean addBorderEnabled() {
        return this.addBorderEnabled;
    }

    void addBorderEnabled(boolean value) {
        this.addBorderEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

