/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.mergepdfs;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class MergePdfsNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String[] FILE_INPUT_DEFAULT_VALUE = new String[1];
    private String[] fileInput = FILE_INPUT_DEFAULT_VALUE;
    static final String[] SORT_TYPE_VALUES = new String[]{"orderProvided", "byFileName", "byDateModified", "byDateCreated", "byPDFTitle"};
    private static final String SORT_TYPE_KEY = "sortType";
    private static final String SORT_TYPE_DEFAULT_VALUE = "orderProvided";
    private String sortType = "orderProvided";
    private static final String SORT_TYPE_ENABLED_KEY = "sortTypeEnabled";
    private boolean sortTypeEnabled = false;
    private static final String REMOVE_CERT_SIGN_KEY = "removeCertSign";
    private static final boolean REMOVE_CERT_SIGN_DEFAULT_VALUE = false;
    private boolean removeCertSign = false;
    private static final String REMOVE_CERT_SIGN_ENABLED_KEY = "removeCertSignEnabled";
    private boolean removeCertSignEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    MergePdfsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addStringArray(FILE_INPUT_KEY, this.fileInput);
        settings.addString(SORT_TYPE_KEY, this.sortType);
        settings.addBoolean(SORT_TYPE_ENABLED_KEY, this.sortTypeEnabled);
        settings.addBoolean(REMOVE_CERT_SIGN_KEY, this.removeCertSign);
        settings.addBoolean(REMOVE_CERT_SIGN_ENABLED_KEY, this.removeCertSignEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getStringArray(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.sortType = settings.getString(SORT_TYPE_KEY, SORT_TYPE_DEFAULT_VALUE);
        this.sortTypeEnabled = settings.getBoolean(SORT_TYPE_ENABLED_KEY, false);
        this.removeCertSign = settings.getBoolean(REMOVE_CERT_SIGN_KEY, false);
        this.removeCertSignEnabled = settings.getBoolean(REMOVE_CERT_SIGN_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.length == 0) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String[] fileInput() {
        return this.fileInput;
    }

    void fileInput(String[] value) {
        this.fileInput = value;
    }

    String sortType() {
        return this.sortType;
    }

    void sortType(String value) {
        this.sortType = value;
    }

    boolean sortTypeEnabled() {
        return this.sortTypeEnabled;
    }

    void sortTypeEnabled(boolean value) {
        this.sortTypeEnabled = value;
    }

    boolean removeCertSign() {
        return this.removeCertSign;
    }

    void removeCertSign(boolean value) {
        this.removeCertSign = value;
    }

    boolean removeCertSignEnabled() {
        return this.removeCertSignEnabled;
    }

    void removeCertSignEnabled(boolean value) {
        this.removeCertSignEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

