/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.optimizepdf;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class OptimizePdfNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String OPTIMIZE_LEVEL_KEY = "optimizeLevel";
    static final Integer OPTIMIZE_LEVEL_DEFAULT_VALUE = 0;
    static final Integer OPTIMIZE_LEVEL_MINIMUM_VALUE = null;
    static final Integer OPTIMIZE_LEVEL_MAXIMUM_VALUE = null;
    private int optimizeLevel = OPTIMIZE_LEVEL_DEFAULT_VALUE;
    private static final String OPTIMIZE_LEVEL_ENABLED_KEY = "optimizeLevelEnabled";
    private boolean optimizeLevelEnabled = false;
    private static final String EXPECTED_OUTPUT_SIZE_KEY = "expectedOutputSize";
    private static final String EXPECTED_OUTPUT_SIZE_DEFAULT_VALUE = null;
    private String expectedOutputSize = EXPECTED_OUTPUT_SIZE_DEFAULT_VALUE;
    private static final String EXPECTED_OUTPUT_SIZE_ENABLED_KEY = "expectedOutputSizeEnabled";
    private boolean expectedOutputSizeEnabled = false;
    private static final String LINEARIZE_KEY = "linearize";
    private static final boolean LINEARIZE_DEFAULT_VALUE = false;
    private boolean linearize = false;
    private static final String LINEARIZE_ENABLED_KEY = "linearizeEnabled";
    private boolean linearizeEnabled = false;
    private static final String NORMALIZE_KEY = "normalize";
    private static final boolean NORMALIZE_DEFAULT_VALUE = false;
    private boolean normalize = false;
    private static final String NORMALIZE_ENABLED_KEY = "normalizeEnabled";
    private boolean normalizeEnabled = false;
    private static final String GRAYSCALE_KEY = "grayscale";
    private static final boolean GRAYSCALE_DEFAULT_VALUE = false;
    private boolean grayscale = false;
    private static final String GRAYSCALE_ENABLED_KEY = "grayscaleEnabled";
    private boolean grayscaleEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    OptimizePdfNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addInt(OPTIMIZE_LEVEL_KEY, this.optimizeLevel);
        settings.addBoolean(OPTIMIZE_LEVEL_ENABLED_KEY, this.optimizeLevelEnabled);
        settings.addString(EXPECTED_OUTPUT_SIZE_KEY, this.expectedOutputSize);
        settings.addBoolean(EXPECTED_OUTPUT_SIZE_ENABLED_KEY, this.expectedOutputSizeEnabled);
        settings.addBoolean(LINEARIZE_KEY, this.linearize);
        settings.addBoolean(LINEARIZE_ENABLED_KEY, this.linearizeEnabled);
        settings.addBoolean(NORMALIZE_KEY, this.normalize);
        settings.addBoolean(NORMALIZE_ENABLED_KEY, this.normalizeEnabled);
        settings.addBoolean(GRAYSCALE_KEY, this.grayscale);
        settings.addBoolean(GRAYSCALE_ENABLED_KEY, this.grayscaleEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.optimizeLevel = settings.getInt(OPTIMIZE_LEVEL_KEY, OPTIMIZE_LEVEL_DEFAULT_VALUE.intValue());
        this.optimizeLevelEnabled = settings.getBoolean(OPTIMIZE_LEVEL_ENABLED_KEY, false);
        this.expectedOutputSize = settings.getString(EXPECTED_OUTPUT_SIZE_KEY, EXPECTED_OUTPUT_SIZE_DEFAULT_VALUE);
        this.expectedOutputSizeEnabled = settings.getBoolean(EXPECTED_OUTPUT_SIZE_ENABLED_KEY, false);
        this.linearize = settings.getBoolean(LINEARIZE_KEY, false);
        this.linearizeEnabled = settings.getBoolean(LINEARIZE_ENABLED_KEY, false);
        this.normalize = settings.getBoolean(NORMALIZE_KEY, false);
        this.normalizeEnabled = settings.getBoolean(NORMALIZE_ENABLED_KEY, false);
        this.grayscale = settings.getBoolean(GRAYSCALE_KEY, false);
        this.grayscaleEnabled = settings.getBoolean(GRAYSCALE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    int optimizeLevel() {
        return this.optimizeLevel;
    }

    void optimizeLevel(int value) {
        this.optimizeLevel = value;
    }

    boolean optimizeLevelEnabled() {
        return this.optimizeLevelEnabled;
    }

    void optimizeLevelEnabled(boolean value) {
        this.optimizeLevelEnabled = value;
    }

    String expectedOutputSize() {
        return this.expectedOutputSize;
    }

    void expectedOutputSize(String value) {
        this.expectedOutputSize = value;
    }

    boolean expectedOutputSizeEnabled() {
        return this.expectedOutputSizeEnabled;
    }

    void expectedOutputSizeEnabled(boolean value) {
        this.expectedOutputSizeEnabled = value;
    }

    boolean linearize() {
        return this.linearize;
    }

    void linearize(boolean value) {
        this.linearize = value;
    }

    boolean linearizeEnabled() {
        return this.linearizeEnabled;
    }

    void linearizeEnabled(boolean value) {
        this.linearizeEnabled = value;
    }

    boolean normalize() {
        return this.normalize;
    }

    void normalize(boolean value) {
        this.normalize = value;
    }

    boolean normalizeEnabled() {
        return this.normalizeEnabled;
    }

    void normalizeEnabled(boolean value) {
        this.normalizeEnabled = value;
    }

    boolean grayscale() {
        return this.grayscale;
    }

    void grayscale(boolean value) {
        this.grayscale = value;
    }

    boolean grayscaleEnabled() {
        return this.grayscaleEnabled;
    }

    void grayscaleEnabled(boolean value) {
        this.grayscaleEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

