/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.overlaypdfs;

import com.nodepit.nodes.stirlingpdf.v1.ArrayInput;
import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.overlaypdfs.OverlayPdfsNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class OverlayPdfsNodeDialog
extends NodeDialogPane {
    private final OverlayPdfsNodeSettings nodeSettings = new OverlayPdfsNodeSettings();
    private FilePicker fileInput;
    private ArrayInput overlayFiles;
    private JCheckBox overlayFilesEnabled;
    private JTextField overlayMode;
    private ArrayInput counts;
    private JCheckBox countsEnabled;
    private JSpinner overlayPosition;
    private JCheckBox overlayPositionEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    OverlayPdfsNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Overlay Files:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.overlayFilesEnabled = new JCheckBox();
        this.overlayFilesEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.overlayFilesEnabled.setSelected(!this.overlayFilesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.overlayFilesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.overlayFiles = ArrayInput.textFields();
        panel.add((Component)this.overlayFiles, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Overlay Mode:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.overlayMode = new JTextField(30);
        panel.add((Component)this.overlayMode, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Counts:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.countsEnabled = new JCheckBox();
        this.countsEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.countsEnabled.setSelected(!this.countsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.countsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.counts = ArrayInput.textFields();
        panel.add((Component)this.counts, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Overlay Position:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.overlayPositionEnabled = new JCheckBox();
        this.overlayPositionEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.overlayPositionEnabled.setSelected(!this.overlayPositionEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.overlayPositionEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.overlayPosition = new JSpinner(new SpinnerNumberModel(OverlayPdfsNodeSettings.OVERLAY_POSITION_DEFAULT_VALUE, OverlayPdfsNodeSettings.OVERLAY_POSITION_MINIMUM_VALUE, OverlayPdfsNodeSettings.OVERLAY_POSITION_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.overlayPosition, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(OverlayPdfsNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.overlayFiles.setEnabled(this.overlayFilesEnabled.isSelected());
        this.counts.setEnabled(this.countsEnabled.isSelected());
        this.overlayPosition.setEnabled(this.overlayPositionEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.overlayFiles(this.overlayFiles.getValues());
        this.nodeSettings.overlayFilesEnabled(this.overlayFilesEnabled.isSelected());
        this.nodeSettings.overlayMode(this.overlayMode.getText());
        this.nodeSettings.counts(this.counts.getValues());
        this.nodeSettings.countsEnabled(this.countsEnabled.isSelected());
        this.nodeSettings.overlayPosition((Integer)this.overlayPosition.getValue());
        this.nodeSettings.overlayPositionEnabled(this.overlayPositionEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.overlayFiles.setValues(this.nodeSettings.overlayFiles());
        this.overlayFilesEnabled.setSelected(this.nodeSettings.overlayFilesEnabled());
        this.overlayMode.setText(this.nodeSettings.overlayMode());
        this.counts.setValues(this.nodeSettings.counts());
        this.countsEnabled.setSelected(this.nodeSettings.countsEnabled());
        this.overlayPosition.setValue(this.nodeSettings.overlayPosition());
        this.overlayPositionEnabled.setSelected(this.nodeSettings.overlayPositionEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

