/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.pagesize;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class PageSizeNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    static final String[] COMPARATOR_VALUES = new String[]{"Greater", "Equal", "Less"};
    private static final String COMPARATOR_KEY = "comparator";
    private static final String COMPARATOR_DEFAULT_VALUE = COMPARATOR_VALUES[0];
    private String comparator = COMPARATOR_DEFAULT_VALUE;
    private static final String COMPARATOR_ENABLED_KEY = "comparatorEnabled";
    private boolean comparatorEnabled = false;
    private static final String STANDARD_PAGE_SIZE_KEY = "standardPageSize";
    private static final String STANDARD_PAGE_SIZE_DEFAULT_VALUE = null;
    private String standardPageSize = STANDARD_PAGE_SIZE_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    PageSizeNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(COMPARATOR_KEY, this.comparator);
        settings.addBoolean(COMPARATOR_ENABLED_KEY, this.comparatorEnabled);
        settings.addString(STANDARD_PAGE_SIZE_KEY, this.standardPageSize);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.comparator = settings.getString(COMPARATOR_KEY, COMPARATOR_DEFAULT_VALUE);
        this.comparatorEnabled = settings.getBoolean(COMPARATOR_ENABLED_KEY, false);
        this.standardPageSize = settings.getString(STANDARD_PAGE_SIZE_KEY, STANDARD_PAGE_SIZE_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.standardPageSize == null || this.standardPageSize.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cStandard Page Size\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String comparator() {
        return this.comparator;
    }

    void comparator(String value) {
        this.comparator = value;
    }

    boolean comparatorEnabled() {
        return this.comparatorEnabled;
    }

    void comparatorEnabled(boolean value) {
        this.comparatorEnabled = value;
    }

    String standardPageSize() {
        return this.standardPageSize;
    }

    void standardPageSize(String value) {
        this.standardPageSize = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

