/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.processpdftoword;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.processpdftoword.ProcessPdfToWordNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ProcessPdfToWordNodeDialog
extends NodeDialogPane {
    private final ProcessPdfToWordNodeSettings nodeSettings = new ProcessPdfToWordNodeSettings();
    private FilePicker fileInput;
    private JComboBox<String> outputFormat;
    private JCheckBox outputFormatEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ProcessPdfToWordNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Output Format:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.outputFormatEnabled = new JCheckBox();
        this.outputFormatEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.outputFormatEnabled.setSelected(!this.outputFormatEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.outputFormatEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.outputFormat = new JComboBox<String>(ProcessPdfToWordNodeSettings.OUTPUT_FORMAT_VALUES);
        panel.add(this.outputFormat, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ProcessPdfToWordNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.outputFormat.setEnabled(this.outputFormatEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.outputFormat((String)this.outputFormat.getSelectedItem());
        this.nodeSettings.outputFormatEnabled(this.outputFormatEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.outputFormat.setSelectedItem(this.nodeSettings.outputFormat());
        this.outputFormatEnabled.setSelected(this.nodeSettings.outputFormatEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

