/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.redactpdf;

import com.nodepit.nodes.stirlingpdf.v1.ArrayInput;
import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.redactpdf.RedactPDFNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class RedactPDFNodeDialog
extends NodeDialogPane {
    private final RedactPDFNodeSettings nodeSettings = new RedactPDFNodeSettings();
    private FilePicker fileInput;
    private JTextField pageNumbers;
    private JCheckBox pageNumbersEnabled;
    private ArrayInput redactions;
    private JCheckBox redactionsEnabled;
    private JCheckBox convertPDFToImage;
    private JCheckBox convertPDFToImageEnabled;
    private JTextField pageRedactionColor;
    private JCheckBox pageRedactionColorEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    RedactPDFNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Page Numbers:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.pageNumbersEnabled = new JCheckBox();
        this.pageNumbersEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.pageNumbersEnabled.setSelected(!this.pageNumbersEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pageNumbersEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pageNumbers = new JTextField(30);
        panel.add((Component)this.pageNumbers, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Redactions:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.redactionsEnabled = new JCheckBox();
        this.redactionsEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.redactionsEnabled.setSelected(!this.redactionsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.redactionsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.redactions = ArrayInput.textFields();
        panel.add((Component)this.redactions, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Convert PDF to Image:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.convertPDFToImageEnabled = new JCheckBox();
        this.convertPDFToImageEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.convertPDFToImageEnabled.setSelected(!this.convertPDFToImageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.convertPDFToImageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.convertPDFToImage = new JCheckBox("true");
        panel.add((Component)this.convertPDFToImage, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Page Redaction Color:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.pageRedactionColorEnabled = new JCheckBox();
        this.pageRedactionColorEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.pageRedactionColorEnabled.setSelected(!this.pageRedactionColorEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pageRedactionColorEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pageRedactionColor = new JTextField(30);
        panel.add((Component)this.pageRedactionColor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(RedactPDFNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.pageNumbers.setEnabled(this.pageNumbersEnabled.isSelected());
        this.redactions.setEnabled(this.redactionsEnabled.isSelected());
        this.convertPDFToImage.setEnabled(this.convertPDFToImageEnabled.isSelected());
        this.pageRedactionColor.setEnabled(this.pageRedactionColorEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.pageNumbers(this.pageNumbers.getText());
        this.nodeSettings.pageNumbersEnabled(this.pageNumbersEnabled.isSelected());
        this.nodeSettings.redactions(this.redactions.getValues());
        this.nodeSettings.redactionsEnabled(this.redactionsEnabled.isSelected());
        this.nodeSettings.convertPDFToImage(this.convertPDFToImage.isSelected());
        this.nodeSettings.convertPDFToImageEnabled(this.convertPDFToImageEnabled.isSelected());
        this.nodeSettings.pageRedactionColor(this.pageRedactionColor.getText());
        this.nodeSettings.pageRedactionColorEnabled(this.pageRedactionColorEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.pageNumbers.setText(this.nodeSettings.pageNumbers());
        this.pageNumbersEnabled.setSelected(this.nodeSettings.pageNumbersEnabled());
        this.redactions.setValues(this.nodeSettings.redactions());
        this.redactionsEnabled.setSelected(this.nodeSettings.redactionsEnabled());
        this.convertPDFToImage.setSelected(this.nodeSettings.convertPDFToImage());
        this.convertPDFToImageEnabled.setSelected(this.nodeSettings.convertPDFToImageEnabled());
        this.pageRedactionColor.setText(this.nodeSettings.pageRedactionColor());
        this.pageRedactionColorEnabled.setSelected(this.nodeSettings.pageRedactionColorEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

