/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.redactpdf;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RedactPDFNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String PAGE_NUMBERS_KEY = "pageNumbers";
    private static final String PAGE_NUMBERS_DEFAULT_VALUE = "all";
    private String pageNumbers = "all";
    private static final String PAGE_NUMBERS_ENABLED_KEY = "pageNumbersEnabled";
    private boolean pageNumbersEnabled = false;
    private static final String REDACTIONS_KEY = "redactions";
    private static final String[] REDACTIONS_DEFAULT_VALUE = new String[1];
    private String[] redactions = REDACTIONS_DEFAULT_VALUE;
    private static final String REDACTIONS_ENABLED_KEY = "redactionsEnabled";
    private boolean redactionsEnabled = false;
    private static final String CONVERT_PDF_TO_IMAGE_KEY = "convertPDFToImage";
    private static final boolean CONVERT_PDF_TO_IMAGE_DEFAULT_VALUE = false;
    private boolean convertPDFToImage = false;
    private static final String CONVERT_PDF_TO_IMAGE_ENABLED_KEY = "convertPDFToImageEnabled";
    private boolean convertPDFToImageEnabled = false;
    private static final String PAGE_REDACTION_COLOR_KEY = "pageRedactionColor";
    private static final String PAGE_REDACTION_COLOR_DEFAULT_VALUE = null;
    private String pageRedactionColor = PAGE_REDACTION_COLOR_DEFAULT_VALUE;
    private static final String PAGE_REDACTION_COLOR_ENABLED_KEY = "pageRedactionColorEnabled";
    private boolean pageRedactionColorEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    RedactPDFNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(PAGE_NUMBERS_KEY, this.pageNumbers);
        settings.addBoolean(PAGE_NUMBERS_ENABLED_KEY, this.pageNumbersEnabled);
        settings.addStringArray(REDACTIONS_KEY, this.redactions);
        settings.addBoolean(REDACTIONS_ENABLED_KEY, this.redactionsEnabled);
        settings.addBoolean(CONVERT_PDF_TO_IMAGE_KEY, this.convertPDFToImage);
        settings.addBoolean(CONVERT_PDF_TO_IMAGE_ENABLED_KEY, this.convertPDFToImageEnabled);
        settings.addString(PAGE_REDACTION_COLOR_KEY, this.pageRedactionColor);
        settings.addBoolean(PAGE_REDACTION_COLOR_ENABLED_KEY, this.pageRedactionColorEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.pageNumbers = settings.getString(PAGE_NUMBERS_KEY, PAGE_NUMBERS_DEFAULT_VALUE);
        this.pageNumbersEnabled = settings.getBoolean(PAGE_NUMBERS_ENABLED_KEY, false);
        this.redactions = settings.getStringArray(REDACTIONS_KEY, REDACTIONS_DEFAULT_VALUE);
        this.redactionsEnabled = settings.getBoolean(REDACTIONS_ENABLED_KEY, false);
        this.convertPDFToImage = settings.getBoolean(CONVERT_PDF_TO_IMAGE_KEY, false);
        this.convertPDFToImageEnabled = settings.getBoolean(CONVERT_PDF_TO_IMAGE_ENABLED_KEY, false);
        this.pageRedactionColor = settings.getString(PAGE_REDACTION_COLOR_KEY, PAGE_REDACTION_COLOR_DEFAULT_VALUE);
        this.pageRedactionColorEnabled = settings.getBoolean(PAGE_REDACTION_COLOR_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String pageNumbers() {
        return this.pageNumbers;
    }

    void pageNumbers(String value) {
        this.pageNumbers = value;
    }

    boolean pageNumbersEnabled() {
        return this.pageNumbersEnabled;
    }

    void pageNumbersEnabled(boolean value) {
        this.pageNumbersEnabled = value;
    }

    String[] redactions() {
        return this.redactions;
    }

    void redactions(String[] value) {
        this.redactions = value;
    }

    boolean redactionsEnabled() {
        return this.redactionsEnabled;
    }

    void redactionsEnabled(boolean value) {
        this.redactionsEnabled = value;
    }

    boolean convertPDFToImage() {
        return this.convertPDFToImage;
    }

    void convertPDFToImage(boolean value) {
        this.convertPDFToImage = value;
    }

    boolean convertPDFToImageEnabled() {
        return this.convertPDFToImageEnabled;
    }

    void convertPDFToImageEnabled(boolean value) {
        this.convertPDFToImageEnabled = value;
    }

    String pageRedactionColor() {
        return this.pageRedactionColor;
    }

    void pageRedactionColor(String value) {
        this.pageRedactionColor = value;
    }

    boolean pageRedactionColorEnabled() {
        return this.pageRedactionColorEnabled;
    }

    void pageRedactionColorEnabled(boolean value) {
        this.pageRedactionColorEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

