/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.replaceandinvertcolor;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.replaceandinvertcolor.ReplaceAndInvertColorNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ReplaceAndInvertColorNodeDialog
extends NodeDialogPane {
    private final ReplaceAndInvertColorNodeSettings nodeSettings = new ReplaceAndInvertColorNodeSettings();
    private FilePicker fileInput;
    private JComboBox<String> replaceAndInvertOption;
    private JCheckBox replaceAndInvertOptionEnabled;
    private JComboBox<String> highContrastColorCombination;
    private JCheckBox highContrastColorCombinationEnabled;
    private JTextField backGroundColor;
    private JCheckBox backGroundColorEnabled;
    private JTextField textColor;
    private JCheckBox textColorEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ReplaceAndInvertColorNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Replace and Invert Option:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.replaceAndInvertOptionEnabled = new JCheckBox();
        this.replaceAndInvertOptionEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.replaceAndInvertOptionEnabled.setSelected(!this.replaceAndInvertOptionEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.replaceAndInvertOptionEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.replaceAndInvertOption = new JComboBox<String>(ReplaceAndInvertColorNodeSettings.REPLACE_AND_INVERT_OPTION_VALUES);
        panel.add(this.replaceAndInvertOption, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("High Contrast Color Combination:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.highContrastColorCombinationEnabled = new JCheckBox();
        this.highContrastColorCombinationEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.highContrastColorCombinationEnabled.setSelected(!this.highContrastColorCombinationEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.highContrastColorCombinationEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.highContrastColorCombination = new JComboBox<String>(ReplaceAndInvertColorNodeSettings.HIGH_CONTRAST_COLOR_COMBINATION_VALUES);
        panel.add(this.highContrastColorCombination, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Back Ground Color:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.backGroundColorEnabled = new JCheckBox();
        this.backGroundColorEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.backGroundColorEnabled.setSelected(!this.backGroundColorEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.backGroundColorEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.backGroundColor = new JTextField(30);
        panel.add((Component)this.backGroundColor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Text Color:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.textColorEnabled = new JCheckBox();
        this.textColorEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.textColorEnabled.setSelected(!this.textColorEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.textColorEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textColor = new JTextField(30);
        panel.add((Component)this.textColor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ReplaceAndInvertColorNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.replaceAndInvertOption.setEnabled(this.replaceAndInvertOptionEnabled.isSelected());
        this.highContrastColorCombination.setEnabled(this.highContrastColorCombinationEnabled.isSelected());
        this.backGroundColor.setEnabled(this.backGroundColorEnabled.isSelected());
        this.textColor.setEnabled(this.textColorEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.replaceAndInvertOption((String)this.replaceAndInvertOption.getSelectedItem());
        this.nodeSettings.replaceAndInvertOptionEnabled(this.replaceAndInvertOptionEnabled.isSelected());
        this.nodeSettings.highContrastColorCombination((String)this.highContrastColorCombination.getSelectedItem());
        this.nodeSettings.highContrastColorCombinationEnabled(this.highContrastColorCombinationEnabled.isSelected());
        this.nodeSettings.backGroundColor(this.backGroundColor.getText());
        this.nodeSettings.backGroundColorEnabled(this.backGroundColorEnabled.isSelected());
        this.nodeSettings.textColor(this.textColor.getText());
        this.nodeSettings.textColorEnabled(this.textColorEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.replaceAndInvertOption.setSelectedItem(this.nodeSettings.replaceAndInvertOption());
        this.replaceAndInvertOptionEnabled.setSelected(this.nodeSettings.replaceAndInvertOptionEnabled());
        this.highContrastColorCombination.setSelectedItem(this.nodeSettings.highContrastColorCombination());
        this.highContrastColorCombinationEnabled.setSelected(this.nodeSettings.highContrastColorCombinationEnabled());
        this.backGroundColor.setText(this.nodeSettings.backGroundColor());
        this.backGroundColorEnabled.setSelected(this.nodeSettings.backGroundColorEnabled());
        this.textColor.setText(this.nodeSettings.textColor());
        this.textColorEnabled.setSelected(this.nodeSettings.textColorEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

