/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.scalepages;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ScalePagesNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    static final String[] PAGE_SIZE_VALUES = new String[]{"A0", "A1", "A2", "A3", "A4", "A5", "A6", "LETTER", "LEGAL", "KEEP"};
    private static final String PAGE_SIZE_KEY = "pageSize";
    private static final String PAGE_SIZE_DEFAULT_VALUE = PAGE_SIZE_VALUES[0];
    private String pageSize = PAGE_SIZE_DEFAULT_VALUE;
    private static final String PAGE_SIZE_ENABLED_KEY = "pageSizeEnabled";
    private boolean pageSizeEnabled = false;
    private static final String SCALE_FACTOR_KEY = "scaleFactor";
    private static final String SCALE_FACTOR_DEFAULT_VALUE = null;
    private String scaleFactor = SCALE_FACTOR_DEFAULT_VALUE;
    private static final String SCALE_FACTOR_ENABLED_KEY = "scaleFactorEnabled";
    private boolean scaleFactorEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ScalePagesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(PAGE_SIZE_KEY, this.pageSize);
        settings.addBoolean(PAGE_SIZE_ENABLED_KEY, this.pageSizeEnabled);
        settings.addString(SCALE_FACTOR_KEY, this.scaleFactor);
        settings.addBoolean(SCALE_FACTOR_ENABLED_KEY, this.scaleFactorEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.pageSize = settings.getString(PAGE_SIZE_KEY, PAGE_SIZE_DEFAULT_VALUE);
        this.pageSizeEnabled = settings.getBoolean(PAGE_SIZE_ENABLED_KEY, false);
        this.scaleFactor = settings.getString(SCALE_FACTOR_KEY, SCALE_FACTOR_DEFAULT_VALUE);
        this.scaleFactorEnabled = settings.getBoolean(SCALE_FACTOR_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String pageSize() {
        return this.pageSize;
    }

    void pageSize(String value) {
        this.pageSize = value;
    }

    boolean pageSizeEnabled() {
        return this.pageSizeEnabled;
    }

    void pageSizeEnabled(boolean value) {
        this.pageSizeEnabled = value;
    }

    String scaleFactor() {
        return this.scaleFactor;
    }

    void scaleFactor(String value) {
        this.scaleFactor = value;
    }

    boolean scaleFactorEnabled() {
        return this.scaleFactorEnabled;
    }

    void scaleFactorEnabled(boolean value) {
        this.scaleFactorEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

