/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.sendemailwithattachment;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SendEmailWithAttachmentNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String TO_KEY = "to";
    private static final String TO_DEFAULT_VALUE = null;
    private String to = TO_DEFAULT_VALUE;
    private static final String SUBJECT_KEY = "subject";
    private static final String SUBJECT_DEFAULT_VALUE = "Stirling Software PDF Notification";
    private String subject = "Stirling Software PDF Notification";
    private static final String SUBJECT_ENABLED_KEY = "subjectEnabled";
    private boolean subjectEnabled = false;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = "This message was automatically generated by Stirling-PDF, an innovative solution from Stirling Software. For more information, visit our &lt;a href&#x3D;&quot;https://stirling-software.com&quot;&gt;website&lt;/a&gt;.&lt;br&gt;&lt;br&gt;Please do not reply directly to this email.";
    private String body = "This message was automatically generated by Stirling-PDF, an innovative solution from Stirling Software. For more information, visit our &lt;a href&#x3D;&quot;https://stirling-software.com&quot;&gt;website&lt;/a&gt;.&lt;br&gt;&lt;br&gt;Please do not reply directly to this email.";
    private static final String BODY_ENABLED_KEY = "bodyEnabled";
    private boolean bodyEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SendEmailWithAttachmentNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addString(TO_KEY, this.to);
        settings.addString(SUBJECT_KEY, this.subject);
        settings.addBoolean(SUBJECT_ENABLED_KEY, this.subjectEnabled);
        settings.addString(BODY_KEY, this.body);
        settings.addBoolean(BODY_ENABLED_KEY, this.bodyEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.to = settings.getString(TO_KEY, TO_DEFAULT_VALUE);
        this.subject = settings.getString(SUBJECT_KEY, SUBJECT_DEFAULT_VALUE);
        this.subjectEnabled = settings.getBoolean(SUBJECT_ENABLED_KEY, false);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.bodyEnabled = settings.getBoolean(BODY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.to == null || this.to.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTo\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String to() {
        return this.to;
    }

    void to(String value) {
        this.to = value;
    }

    String subject() {
        return this.subject;
    }

    void subject(String value) {
        this.subject = value;
    }

    boolean subjectEnabled() {
        return this.subjectEnabled;
    }

    void subjectEnabled(boolean value) {
        this.subjectEnabled = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    boolean bodyEnabled() {
        return this.bodyEnabled;
    }

    void bodyEnabled(boolean value) {
        this.bodyEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

