/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.splitpdf;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.splitpdf.SplitPdfNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class SplitPdfNodeDialog
extends NodeDialogPane {
    private final SplitPdfNodeSettings nodeSettings = new SplitPdfNodeSettings();
    private FilePicker fileInput;
    private JSpinner horizontalDivisions;
    private JCheckBox horizontalDivisionsEnabled;
    private JSpinner verticalDivisions;
    private JCheckBox verticalDivisionsEnabled;
    private JCheckBox merge;
    private JCheckBox mergeEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    SplitPdfNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Horizontal Divisions:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.horizontalDivisionsEnabled = new JCheckBox();
        this.horizontalDivisionsEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.horizontalDivisionsEnabled.setSelected(!this.horizontalDivisionsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.horizontalDivisionsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.horizontalDivisions = new JSpinner(new SpinnerNumberModel(SplitPdfNodeSettings.HORIZONTAL_DIVISIONS_DEFAULT_VALUE, SplitPdfNodeSettings.HORIZONTAL_DIVISIONS_MINIMUM_VALUE, SplitPdfNodeSettings.HORIZONTAL_DIVISIONS_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.horizontalDivisions, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Vertical Divisions:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.verticalDivisionsEnabled = new JCheckBox();
        this.verticalDivisionsEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.verticalDivisionsEnabled.setSelected(!this.verticalDivisionsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.verticalDivisionsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.verticalDivisions = new JSpinner(new SpinnerNumberModel(SplitPdfNodeSettings.VERTICAL_DIVISIONS_DEFAULT_VALUE, SplitPdfNodeSettings.VERTICAL_DIVISIONS_MINIMUM_VALUE, SplitPdfNodeSettings.VERTICAL_DIVISIONS_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.verticalDivisions, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Merge:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.mergeEnabled = new JCheckBox();
        this.mergeEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.mergeEnabled.setSelected(!this.mergeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.mergeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.merge = new JCheckBox("true");
        panel.add((Component)this.merge, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(SplitPdfNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.horizontalDivisions.setEnabled(this.horizontalDivisionsEnabled.isSelected());
        this.verticalDivisions.setEnabled(this.verticalDivisionsEnabled.isSelected());
        this.merge.setEnabled(this.mergeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.horizontalDivisions((Integer)this.horizontalDivisions.getValue());
        this.nodeSettings.horizontalDivisionsEnabled(this.horizontalDivisionsEnabled.isSelected());
        this.nodeSettings.verticalDivisions((Integer)this.verticalDivisions.getValue());
        this.nodeSettings.verticalDivisionsEnabled(this.verticalDivisionsEnabled.isSelected());
        this.nodeSettings.merge(this.merge.isSelected());
        this.nodeSettings.mergeEnabled(this.mergeEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.horizontalDivisions.setValue(this.nodeSettings.horizontalDivisions());
        this.horizontalDivisionsEnabled.setSelected(this.nodeSettings.horizontalDivisionsEnabled());
        this.verticalDivisions.setValue(this.nodeSettings.verticalDivisions());
        this.verticalDivisionsEnabled.setSelected(this.nodeSettings.verticalDivisionsEnabled());
        this.merge.setSelected(this.nodeSettings.merge());
        this.mergeEnabled.setSelected(this.nodeSettings.mergeEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

