/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.splitpdf;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SplitPdfNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String HORIZONTAL_DIVISIONS_KEY = "horizontalDivisions";
    static final Integer HORIZONTAL_DIVISIONS_DEFAULT_VALUE = 0;
    static final Integer HORIZONTAL_DIVISIONS_MINIMUM_VALUE = null;
    static final Integer HORIZONTAL_DIVISIONS_MAXIMUM_VALUE = null;
    private int horizontalDivisions = HORIZONTAL_DIVISIONS_DEFAULT_VALUE;
    private static final String HORIZONTAL_DIVISIONS_ENABLED_KEY = "horizontalDivisionsEnabled";
    private boolean horizontalDivisionsEnabled = false;
    private static final String VERTICAL_DIVISIONS_KEY = "verticalDivisions";
    static final Integer VERTICAL_DIVISIONS_DEFAULT_VALUE = 0;
    static final Integer VERTICAL_DIVISIONS_MINIMUM_VALUE = null;
    static final Integer VERTICAL_DIVISIONS_MAXIMUM_VALUE = null;
    private int verticalDivisions = VERTICAL_DIVISIONS_DEFAULT_VALUE;
    private static final String VERTICAL_DIVISIONS_ENABLED_KEY = "verticalDivisionsEnabled";
    private boolean verticalDivisionsEnabled = false;
    private static final String MERGE_KEY = "merge";
    private static final boolean MERGE_DEFAULT_VALUE = false;
    private boolean merge = false;
    private static final String MERGE_ENABLED_KEY = "mergeEnabled";
    private boolean mergeEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SplitPdfNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addInt(HORIZONTAL_DIVISIONS_KEY, this.horizontalDivisions);
        settings.addBoolean(HORIZONTAL_DIVISIONS_ENABLED_KEY, this.horizontalDivisionsEnabled);
        settings.addInt(VERTICAL_DIVISIONS_KEY, this.verticalDivisions);
        settings.addBoolean(VERTICAL_DIVISIONS_ENABLED_KEY, this.verticalDivisionsEnabled);
        settings.addBoolean(MERGE_KEY, this.merge);
        settings.addBoolean(MERGE_ENABLED_KEY, this.mergeEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.horizontalDivisions = settings.getInt(HORIZONTAL_DIVISIONS_KEY, HORIZONTAL_DIVISIONS_DEFAULT_VALUE.intValue());
        this.horizontalDivisionsEnabled = settings.getBoolean(HORIZONTAL_DIVISIONS_ENABLED_KEY, false);
        this.verticalDivisions = settings.getInt(VERTICAL_DIVISIONS_KEY, VERTICAL_DIVISIONS_DEFAULT_VALUE.intValue());
        this.verticalDivisionsEnabled = settings.getBoolean(VERTICAL_DIVISIONS_ENABLED_KEY, false);
        this.merge = settings.getBoolean(MERGE_KEY, false);
        this.mergeEnabled = settings.getBoolean(MERGE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    int horizontalDivisions() {
        return this.horizontalDivisions;
    }

    void horizontalDivisions(int value) {
        this.horizontalDivisions = value;
    }

    boolean horizontalDivisionsEnabled() {
        return this.horizontalDivisionsEnabled;
    }

    void horizontalDivisionsEnabled(boolean value) {
        this.horizontalDivisionsEnabled = value;
    }

    int verticalDivisions() {
        return this.verticalDivisions;
    }

    void verticalDivisions(int value) {
        this.verticalDivisions = value;
    }

    boolean verticalDivisionsEnabled() {
        return this.verticalDivisionsEnabled;
    }

    void verticalDivisionsEnabled(boolean value) {
        this.verticalDivisionsEnabled = value;
    }

    boolean merge() {
        return this.merge;
    }

    void merge(boolean value) {
        this.merge = value;
    }

    boolean mergeEnabled() {
        return this.mergeEnabled;
    }

    void mergeEnabled(boolean value) {
        this.mergeEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

