/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.splitpdf1;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SplitPdf1NodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String INCLUDE_METADATA_KEY = "includeMetadata";
    private static final boolean INCLUDE_METADATA_DEFAULT_VALUE = false;
    private boolean includeMetadata = false;
    private static final String INCLUDE_METADATA_ENABLED_KEY = "includeMetadataEnabled";
    private boolean includeMetadataEnabled = false;
    private static final String ALLOW_DUPLICATES_KEY = "allowDuplicates";
    private static final boolean ALLOW_DUPLICATES_DEFAULT_VALUE = false;
    private boolean allowDuplicates = false;
    private static final String ALLOW_DUPLICATES_ENABLED_KEY = "allowDuplicatesEnabled";
    private boolean allowDuplicatesEnabled = false;
    private static final String BOOKMARK_LEVEL_KEY = "bookmarkLevel";
    static final Integer BOOKMARK_LEVEL_DEFAULT_VALUE = 0;
    static final Integer BOOKMARK_LEVEL_MINIMUM_VALUE = null;
    static final Integer BOOKMARK_LEVEL_MAXIMUM_VALUE = null;
    private int bookmarkLevel = BOOKMARK_LEVEL_DEFAULT_VALUE;
    private static final String BOOKMARK_LEVEL_ENABLED_KEY = "bookmarkLevelEnabled";
    private boolean bookmarkLevelEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SplitPdf1NodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addBoolean(INCLUDE_METADATA_KEY, this.includeMetadata);
        settings.addBoolean(INCLUDE_METADATA_ENABLED_KEY, this.includeMetadataEnabled);
        settings.addBoolean(ALLOW_DUPLICATES_KEY, this.allowDuplicates);
        settings.addBoolean(ALLOW_DUPLICATES_ENABLED_KEY, this.allowDuplicatesEnabled);
        settings.addInt(BOOKMARK_LEVEL_KEY, this.bookmarkLevel);
        settings.addBoolean(BOOKMARK_LEVEL_ENABLED_KEY, this.bookmarkLevelEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.includeMetadata = settings.getBoolean(INCLUDE_METADATA_KEY, false);
        this.includeMetadataEnabled = settings.getBoolean(INCLUDE_METADATA_ENABLED_KEY, false);
        this.allowDuplicates = settings.getBoolean(ALLOW_DUPLICATES_KEY, false);
        this.allowDuplicatesEnabled = settings.getBoolean(ALLOW_DUPLICATES_ENABLED_KEY, false);
        this.bookmarkLevel = settings.getInt(BOOKMARK_LEVEL_KEY, BOOKMARK_LEVEL_DEFAULT_VALUE.intValue());
        this.bookmarkLevelEnabled = settings.getBoolean(BOOKMARK_LEVEL_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    boolean includeMetadata() {
        return this.includeMetadata;
    }

    void includeMetadata(boolean value) {
        this.includeMetadata = value;
    }

    boolean includeMetadataEnabled() {
        return this.includeMetadataEnabled;
    }

    void includeMetadataEnabled(boolean value) {
        this.includeMetadataEnabled = value;
    }

    boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    void allowDuplicates(boolean value) {
        this.allowDuplicates = value;
    }

    boolean allowDuplicatesEnabled() {
        return this.allowDuplicatesEnabled;
    }

    void allowDuplicatesEnabled(boolean value) {
        this.allowDuplicatesEnabled = value;
    }

    int bookmarkLevel() {
        return this.bookmarkLevel;
    }

    void bookmarkLevel(int value) {
        this.bookmarkLevel = value;
    }

    boolean bookmarkLevelEnabled() {
        return this.bookmarkLevelEnabled;
    }

    void bookmarkLevelEnabled(boolean value) {
        this.bookmarkLevelEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

