/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.addpagenumbers;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.addpagenumbers.AddPageNumbersNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AddPageNumbersNodeDialog
extends NodeDialogPane {
    private final AddPageNumbersNodeSettings nodeSettings = new AddPageNumbersNodeSettings();
    private FilePicker fileInput;
    private JTextField pageNumbers;
    private JCheckBox pageNumbersEnabled;
    private JComboBox<String> customMargin;
    private JCheckBox customMarginEnabled;
    private JTextField fontSize;
    private JComboBox<String> fontType;
    private JSpinner position;
    private JSpinner startingNumber;
    private JTextField pagesToNumber;
    private JCheckBox pagesToNumberEnabled;
    private JTextField customText;
    private JCheckBox customTextEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    AddPageNumbersNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Page Numbers:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.pageNumbersEnabled = new JCheckBox();
        this.pageNumbersEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.pageNumbersEnabled.setSelected(!this.pageNumbersEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pageNumbersEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pageNumbers = new JTextField(30);
        panel.add((Component)this.pageNumbers, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Custom Margin:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.customMarginEnabled = new JCheckBox();
        this.customMarginEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.customMarginEnabled.setSelected(!this.customMarginEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.customMarginEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.customMargin = new JComboBox<String>(AddPageNumbersNodeSettings.CUSTOM_MARGIN_VALUES);
        panel.add(this.customMargin, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Font Size:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fontSize = new JTextField(30);
        panel.add((Component)this.fontSize, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Font Type:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fontType = new JComboBox<String>(AddPageNumbersNodeSettings.FONT_TYPE_VALUES);
        panel.add(this.fontType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Position:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.position = new JSpinner(new SpinnerNumberModel(AddPageNumbersNodeSettings.POSITION_DEFAULT_VALUE, AddPageNumbersNodeSettings.POSITION_MINIMUM_VALUE, AddPageNumbersNodeSettings.POSITION_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.position, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label6 = new LabelButton("Starting Number:");
        panel.add((Component)label6, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.startingNumber = new JSpinner(new SpinnerNumberModel(AddPageNumbersNodeSettings.STARTING_NUMBER_DEFAULT_VALUE, AddPageNumbersNodeSettings.STARTING_NUMBER_MINIMUM_VALUE, AddPageNumbersNodeSettings.STARTING_NUMBER_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.startingNumber, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label7 = new LabelButton("Pages to Number:");
        panel.add((Component)label7, c);
        ++c.gridx;
        c.anchor = 17;
        this.pagesToNumberEnabled = new JCheckBox();
        this.pagesToNumberEnabled.addActionListener(e -> this.updateComponents());
        label7.addActionListener(e -> {
            this.pagesToNumberEnabled.setSelected(!this.pagesToNumberEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pagesToNumberEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pagesToNumber = new JTextField(30);
        panel.add((Component)this.pagesToNumber, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label8 = new LabelButton("Custom Text:");
        panel.add((Component)label8, c);
        ++c.gridx;
        c.anchor = 17;
        this.customTextEnabled = new JCheckBox();
        this.customTextEnabled.addActionListener(e -> this.updateComponents());
        label8.addActionListener(e -> {
            this.customTextEnabled.setSelected(!this.customTextEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.customTextEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.customText = new JTextField(30);
        panel.add((Component)this.customText, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AddPageNumbersNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.pageNumbers.setEnabled(this.pageNumbersEnabled.isSelected());
        this.customMargin.setEnabled(this.customMarginEnabled.isSelected());
        this.pagesToNumber.setEnabled(this.pagesToNumberEnabled.isSelected());
        this.customText.setEnabled(this.customTextEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.pageNumbers(this.pageNumbers.getText());
        this.nodeSettings.pageNumbersEnabled(this.pageNumbersEnabled.isSelected());
        this.nodeSettings.customMargin((String)this.customMargin.getSelectedItem());
        this.nodeSettings.customMarginEnabled(this.customMarginEnabled.isSelected());
        this.nodeSettings.fontSize(this.fontSize.getText());
        this.nodeSettings.fontType((String)this.fontType.getSelectedItem());
        this.nodeSettings.position((Integer)this.position.getValue());
        this.nodeSettings.startingNumber((Integer)this.startingNumber.getValue());
        this.nodeSettings.pagesToNumber(this.pagesToNumber.getText());
        this.nodeSettings.pagesToNumberEnabled(this.pagesToNumberEnabled.isSelected());
        this.nodeSettings.customText(this.customText.getText());
        this.nodeSettings.customTextEnabled(this.customTextEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.pageNumbers.setText(this.nodeSettings.pageNumbers());
        this.pageNumbersEnabled.setSelected(this.nodeSettings.pageNumbersEnabled());
        this.customMargin.setSelectedItem(this.nodeSettings.customMargin());
        this.customMarginEnabled.setSelected(this.nodeSettings.customMarginEnabled());
        this.fontSize.setText(this.nodeSettings.fontSize());
        this.fontType.setSelectedItem(this.nodeSettings.fontType());
        this.position.setValue(this.nodeSettings.position());
        this.startingNumber.setValue(this.nodeSettings.startingNumber());
        this.pagesToNumber.setText(this.nodeSettings.pagesToNumber());
        this.pagesToNumberEnabled.setSelected(this.nodeSettings.pagesToNumberEnabled());
        this.customText.setText(this.nodeSettings.customText());
        this.customTextEnabled.setSelected(this.nodeSettings.customTextEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

