/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.addwatermark;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.addwatermark.AddWatermarkNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AddWatermarkNodeDialog
extends NodeDialogPane {
    private final AddWatermarkNodeSettings nodeSettings = new AddWatermarkNodeSettings();
    private FilePicker fileInput;
    private JComboBox<String> watermarkType;
    private JTextField watermarkText;
    private JCheckBox watermarkTextEnabled;
    private FilePicker watermarkImage;
    private JCheckBox watermarkImageEnabled;
    private JComboBox<String> alphabet;
    private JCheckBox alphabetEnabled;
    private JTextField fontSize;
    private JCheckBox fontSizeEnabled;
    private JTextField rotation;
    private JCheckBox rotationEnabled;
    private JTextField opacity;
    private JCheckBox opacityEnabled;
    private JSpinner widthSpacer;
    private JCheckBox widthSpacerEnabled;
    private JSpinner heightSpacer;
    private JCheckBox heightSpacerEnabled;
    private JTextField customColor;
    private JCheckBox customColorEnabled;
    private JCheckBox convertPDFToImage;
    private JCheckBox convertPDFToImageEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    AddWatermarkNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Watermark Type:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.watermarkType = new JComboBox<String>(AddWatermarkNodeSettings.WATERMARK_TYPE_VALUES);
        panel.add(this.watermarkType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Watermark Text:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.watermarkTextEnabled = new JCheckBox();
        this.watermarkTextEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.watermarkTextEnabled.setSelected(!this.watermarkTextEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.watermarkTextEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.watermarkText = new JTextField(30);
        panel.add((Component)this.watermarkText, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Watermark Image:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.watermarkImageEnabled = new JCheckBox();
        this.watermarkImageEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.watermarkImageEnabled.setSelected(!this.watermarkImageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.watermarkImageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.watermarkImage = new FilePicker();
        panel.add((Component)this.watermarkImage, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Alphabet:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.alphabetEnabled = new JCheckBox();
        this.alphabetEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.alphabetEnabled.setSelected(!this.alphabetEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.alphabetEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.alphabet = new JComboBox<String>(AddWatermarkNodeSettings.ALPHABET_VALUES);
        panel.add(this.alphabet, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Font Size:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        this.fontSizeEnabled = new JCheckBox();
        this.fontSizeEnabled.addActionListener(e -> this.updateComponents());
        label5.addActionListener(e -> {
            this.fontSizeEnabled.setSelected(!this.fontSizeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.fontSizeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fontSize = new JTextField(30);
        panel.add((Component)this.fontSize, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label6 = new LabelButton("Rotation:");
        panel.add((Component)label6, c);
        ++c.gridx;
        c.anchor = 17;
        this.rotationEnabled = new JCheckBox();
        this.rotationEnabled.addActionListener(e -> this.updateComponents());
        label6.addActionListener(e -> {
            this.rotationEnabled.setSelected(!this.rotationEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.rotationEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.rotation = new JTextField(30);
        panel.add((Component)this.rotation, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label7 = new LabelButton("Opacity:");
        panel.add((Component)label7, c);
        ++c.gridx;
        c.anchor = 17;
        this.opacityEnabled = new JCheckBox();
        this.opacityEnabled.addActionListener(e -> this.updateComponents());
        label7.addActionListener(e -> {
            this.opacityEnabled.setSelected(!this.opacityEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.opacityEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.opacity = new JTextField(30);
        panel.add((Component)this.opacity, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label8 = new LabelButton("Width Spacer:");
        panel.add((Component)label8, c);
        ++c.gridx;
        c.anchor = 17;
        this.widthSpacerEnabled = new JCheckBox();
        this.widthSpacerEnabled.addActionListener(e -> this.updateComponents());
        label8.addActionListener(e -> {
            this.widthSpacerEnabled.setSelected(!this.widthSpacerEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.widthSpacerEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.widthSpacer = new JSpinner(new SpinnerNumberModel(AddWatermarkNodeSettings.WIDTH_SPACER_DEFAULT_VALUE, AddWatermarkNodeSettings.WIDTH_SPACER_MINIMUM_VALUE, AddWatermarkNodeSettings.WIDTH_SPACER_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.widthSpacer, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label9 = new LabelButton("Height Spacer:");
        panel.add((Component)label9, c);
        ++c.gridx;
        c.anchor = 17;
        this.heightSpacerEnabled = new JCheckBox();
        this.heightSpacerEnabled.addActionListener(e -> this.updateComponents());
        label9.addActionListener(e -> {
            this.heightSpacerEnabled.setSelected(!this.heightSpacerEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.heightSpacerEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.heightSpacer = new JSpinner(new SpinnerNumberModel(AddWatermarkNodeSettings.HEIGHT_SPACER_DEFAULT_VALUE, AddWatermarkNodeSettings.HEIGHT_SPACER_MINIMUM_VALUE, AddWatermarkNodeSettings.HEIGHT_SPACER_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.heightSpacer, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label10 = new LabelButton("Custom Color:");
        panel.add((Component)label10, c);
        ++c.gridx;
        c.anchor = 17;
        this.customColorEnabled = new JCheckBox();
        this.customColorEnabled.addActionListener(e -> this.updateComponents());
        label10.addActionListener(e -> {
            this.customColorEnabled.setSelected(!this.customColorEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.customColorEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.customColor = new JTextField(30);
        panel.add((Component)this.customColor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label11 = new LabelButton("Convert PDF to Image:");
        panel.add((Component)label11, c);
        ++c.gridx;
        c.anchor = 17;
        this.convertPDFToImageEnabled = new JCheckBox();
        this.convertPDFToImageEnabled.addActionListener(e -> this.updateComponents());
        label11.addActionListener(e -> {
            this.convertPDFToImageEnabled.setSelected(!this.convertPDFToImageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.convertPDFToImageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.convertPDFToImage = new JCheckBox("true");
        panel.add((Component)this.convertPDFToImage, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AddWatermarkNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.watermarkText.setEnabled(this.watermarkTextEnabled.isSelected());
        this.watermarkImage.setEnabled(this.watermarkImageEnabled.isSelected());
        this.alphabet.setEnabled(this.alphabetEnabled.isSelected());
        this.fontSize.setEnabled(this.fontSizeEnabled.isSelected());
        this.rotation.setEnabled(this.rotationEnabled.isSelected());
        this.opacity.setEnabled(this.opacityEnabled.isSelected());
        this.widthSpacer.setEnabled(this.widthSpacerEnabled.isSelected());
        this.heightSpacer.setEnabled(this.heightSpacerEnabled.isSelected());
        this.customColor.setEnabled(this.customColorEnabled.isSelected());
        this.convertPDFToImage.setEnabled(this.convertPDFToImageEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.watermarkType((String)this.watermarkType.getSelectedItem());
        this.nodeSettings.watermarkText(this.watermarkText.getText());
        this.nodeSettings.watermarkTextEnabled(this.watermarkTextEnabled.isSelected());
        this.nodeSettings.watermarkImage(this.watermarkImage.getFile());
        this.nodeSettings.watermarkImageEnabled(this.watermarkImageEnabled.isSelected());
        this.nodeSettings.alphabet((String)this.alphabet.getSelectedItem());
        this.nodeSettings.alphabetEnabled(this.alphabetEnabled.isSelected());
        this.nodeSettings.fontSize(this.fontSize.getText());
        this.nodeSettings.fontSizeEnabled(this.fontSizeEnabled.isSelected());
        this.nodeSettings.rotation(this.rotation.getText());
        this.nodeSettings.rotationEnabled(this.rotationEnabled.isSelected());
        this.nodeSettings.opacity(this.opacity.getText());
        this.nodeSettings.opacityEnabled(this.opacityEnabled.isSelected());
        this.nodeSettings.widthSpacer((Integer)this.widthSpacer.getValue());
        this.nodeSettings.widthSpacerEnabled(this.widthSpacerEnabled.isSelected());
        this.nodeSettings.heightSpacer((Integer)this.heightSpacer.getValue());
        this.nodeSettings.heightSpacerEnabled(this.heightSpacerEnabled.isSelected());
        this.nodeSettings.customColor(this.customColor.getText());
        this.nodeSettings.customColorEnabled(this.customColorEnabled.isSelected());
        this.nodeSettings.convertPDFToImage(this.convertPDFToImage.isSelected());
        this.nodeSettings.convertPDFToImageEnabled(this.convertPDFToImageEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.watermarkType.setSelectedItem(this.nodeSettings.watermarkType());
        this.watermarkText.setText(this.nodeSettings.watermarkText());
        this.watermarkTextEnabled.setSelected(this.nodeSettings.watermarkTextEnabled());
        this.watermarkImage.setFile(this.nodeSettings.watermarkImage());
        this.watermarkImageEnabled.setSelected(this.nodeSettings.watermarkImageEnabled());
        this.alphabet.setSelectedItem(this.nodeSettings.alphabet());
        this.alphabetEnabled.setSelected(this.nodeSettings.alphabetEnabled());
        this.fontSize.setText(this.nodeSettings.fontSize());
        this.fontSizeEnabled.setSelected(this.nodeSettings.fontSizeEnabled());
        this.rotation.setText(this.nodeSettings.rotation());
        this.rotationEnabled.setSelected(this.nodeSettings.rotationEnabled());
        this.opacity.setText(this.nodeSettings.opacity());
        this.opacityEnabled.setSelected(this.nodeSettings.opacityEnabled());
        this.widthSpacer.setValue(this.nodeSettings.widthSpacer());
        this.widthSpacerEnabled.setSelected(this.nodeSettings.widthSpacerEnabled());
        this.heightSpacer.setValue(this.nodeSettings.heightSpacer());
        this.heightSpacerEnabled.setSelected(this.nodeSettings.heightSpacerEnabled());
        this.customColor.setText(this.nodeSettings.customColor());
        this.customColorEnabled.setSelected(this.nodeSettings.customColorEnabled());
        this.convertPDFToImage.setSelected(this.nodeSettings.convertPDFToImage());
        this.convertPDFToImageEnabled.setSelected(this.nodeSettings.convertPDFToImageEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

