/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.autoredactpdf;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.autoredactpdf.AutoRedactPdfNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AutoRedactPdfNodeDialog
extends NodeDialogPane {
    private final AutoRedactPdfNodeSettings nodeSettings = new AutoRedactPdfNodeSettings();
    private FilePicker fileInput;
    private JTextField listOfText;
    private JCheckBox useRegex;
    private JCheckBox useRegexEnabled;
    private JCheckBox wholeWordSearch;
    private JCheckBox wholeWordSearchEnabled;
    private JTextField redactColor;
    private JCheckBox redactColorEnabled;
    private JTextField customPadding;
    private JCheckBox customPaddingEnabled;
    private JCheckBox convertPDFToImage;
    private JCheckBox convertPDFToImageEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    AutoRedactPdfNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("List of Text:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.listOfText = new JTextField(30);
        panel.add((Component)this.listOfText, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Use Regex:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.useRegexEnabled = new JCheckBox();
        this.useRegexEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.useRegexEnabled.setSelected(!this.useRegexEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.useRegexEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.useRegex = new JCheckBox("true");
        panel.add((Component)this.useRegex, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Whole Word Search:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.wholeWordSearchEnabled = new JCheckBox();
        this.wholeWordSearchEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.wholeWordSearchEnabled.setSelected(!this.wholeWordSearchEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.wholeWordSearchEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.wholeWordSearch = new JCheckBox("true");
        panel.add((Component)this.wholeWordSearch, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Redact Color:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.redactColorEnabled = new JCheckBox();
        this.redactColorEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.redactColorEnabled.setSelected(!this.redactColorEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.redactColorEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.redactColor = new JTextField(30);
        panel.add((Component)this.redactColor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Custom Padding:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        this.customPaddingEnabled = new JCheckBox();
        this.customPaddingEnabled.addActionListener(e -> this.updateComponents());
        label5.addActionListener(e -> {
            this.customPaddingEnabled.setSelected(!this.customPaddingEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.customPaddingEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.customPadding = new JTextField(30);
        panel.add((Component)this.customPadding, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label6 = new LabelButton("Convert PDF to Image:");
        panel.add((Component)label6, c);
        ++c.gridx;
        c.anchor = 17;
        this.convertPDFToImageEnabled = new JCheckBox();
        this.convertPDFToImageEnabled.addActionListener(e -> this.updateComponents());
        label6.addActionListener(e -> {
            this.convertPDFToImageEnabled.setSelected(!this.convertPDFToImageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.convertPDFToImageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.convertPDFToImage = new JCheckBox("true");
        panel.add((Component)this.convertPDFToImage, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AutoRedactPdfNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.useRegex.setEnabled(this.useRegexEnabled.isSelected());
        this.wholeWordSearch.setEnabled(this.wholeWordSearchEnabled.isSelected());
        this.redactColor.setEnabled(this.redactColorEnabled.isSelected());
        this.customPadding.setEnabled(this.customPaddingEnabled.isSelected());
        this.convertPDFToImage.setEnabled(this.convertPDFToImageEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.listOfText(this.listOfText.getText());
        this.nodeSettings.useRegex(this.useRegex.isSelected());
        this.nodeSettings.useRegexEnabled(this.useRegexEnabled.isSelected());
        this.nodeSettings.wholeWordSearch(this.wholeWordSearch.isSelected());
        this.nodeSettings.wholeWordSearchEnabled(this.wholeWordSearchEnabled.isSelected());
        this.nodeSettings.redactColor(this.redactColor.getText());
        this.nodeSettings.redactColorEnabled(this.redactColorEnabled.isSelected());
        this.nodeSettings.customPadding(this.customPadding.getText());
        this.nodeSettings.customPaddingEnabled(this.customPaddingEnabled.isSelected());
        this.nodeSettings.convertPDFToImage(this.convertPDFToImage.isSelected());
        this.nodeSettings.convertPDFToImageEnabled(this.convertPDFToImageEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.listOfText.setText(this.nodeSettings.listOfText());
        this.useRegex.setSelected(this.nodeSettings.useRegex());
        this.useRegexEnabled.setSelected(this.nodeSettings.useRegexEnabled());
        this.wholeWordSearch.setSelected(this.nodeSettings.wholeWordSearch());
        this.wholeWordSearchEnabled.setSelected(this.nodeSettings.wholeWordSearchEnabled());
        this.redactColor.setText(this.nodeSettings.redactColor());
        this.redactColorEnabled.setSelected(this.nodeSettings.redactColorEnabled());
        this.customPadding.setText(this.nodeSettings.customPadding());
        this.customPaddingEnabled.setSelected(this.nodeSettings.customPaddingEnabled());
        this.convertPDFToImage.setSelected(this.nodeSettings.convertPDFToImage());
        this.convertPDFToImageEnabled.setSelected(this.nodeSettings.convertPDFToImageEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

