/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.autosplitpdf1;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.autosplitpdf1.AutoSplitPdf1NodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AutoSplitPdf1NodeDialog
extends NodeDialogPane {
    private final AutoSplitPdf1NodeSettings nodeSettings = new AutoSplitPdf1NodeSettings();
    private FilePicker fileInput;
    private JSpinner splitType;
    private JCheckBox splitTypeEnabled;
    private JTextField splitValue;
    private JCheckBox splitValueEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    AutoSplitPdf1NodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Split Type:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.splitTypeEnabled = new JCheckBox();
        this.splitTypeEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.splitTypeEnabled.setSelected(!this.splitTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.splitTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.splitType = new JSpinner(new SpinnerNumberModel(AutoSplitPdf1NodeSettings.SPLIT_TYPE_DEFAULT_VALUE, AutoSplitPdf1NodeSettings.SPLIT_TYPE_MINIMUM_VALUE, AutoSplitPdf1NodeSettings.SPLIT_TYPE_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.splitType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Split Value:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.splitValueEnabled = new JCheckBox();
        this.splitValueEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.splitValueEnabled.setSelected(!this.splitValueEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.splitValueEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.splitValue = new JTextField(30);
        panel.add((Component)this.splitValue, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AutoSplitPdf1NodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.splitType.setEnabled(this.splitTypeEnabled.isSelected());
        this.splitValue.setEnabled(this.splitValueEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.splitType((Integer)this.splitType.getValue());
        this.nodeSettings.splitTypeEnabled(this.splitTypeEnabled.isSelected());
        this.nodeSettings.splitValue(this.splitValue.getText());
        this.nodeSettings.splitValueEnabled(this.splitValueEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.splitType.setValue(this.nodeSettings.splitType());
        this.splitTypeEnabled.setSelected(this.nodeSettings.splitTypeEnabled());
        this.splitValue.setText(this.nodeSettings.splitValue());
        this.splitValueEnabled.setSelected(this.nodeSettings.splitValueEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

