/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.autosplitpdf1;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class AutoSplitPdf1NodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String SPLIT_TYPE_KEY = "splitType";
    static final Integer SPLIT_TYPE_DEFAULT_VALUE = 0;
    static final Integer SPLIT_TYPE_MINIMUM_VALUE = null;
    static final Integer SPLIT_TYPE_MAXIMUM_VALUE = null;
    private int splitType = SPLIT_TYPE_DEFAULT_VALUE;
    private static final String SPLIT_TYPE_ENABLED_KEY = "splitTypeEnabled";
    private boolean splitTypeEnabled = false;
    private static final String SPLIT_VALUE_KEY = "splitValue";
    private static final String SPLIT_VALUE_DEFAULT_VALUE = "10MB";
    private String splitValue = "10MB";
    private static final String SPLIT_VALUE_ENABLED_KEY = "splitValueEnabled";
    private boolean splitValueEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    AutoSplitPdf1NodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addInt(SPLIT_TYPE_KEY, this.splitType);
        settings.addBoolean(SPLIT_TYPE_ENABLED_KEY, this.splitTypeEnabled);
        settings.addString(SPLIT_VALUE_KEY, this.splitValue);
        settings.addBoolean(SPLIT_VALUE_ENABLED_KEY, this.splitValueEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.splitType = settings.getInt(SPLIT_TYPE_KEY, SPLIT_TYPE_DEFAULT_VALUE.intValue());
        this.splitTypeEnabled = settings.getBoolean(SPLIT_TYPE_ENABLED_KEY, false);
        this.splitValue = settings.getString(SPLIT_VALUE_KEY, SPLIT_VALUE_DEFAULT_VALUE);
        this.splitValueEnabled = settings.getBoolean(SPLIT_VALUE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    int splitType() {
        return this.splitType;
    }

    void splitType(int value) {
        this.splitType = value;
    }

    boolean splitTypeEnabled() {
        return this.splitTypeEnabled;
    }

    void splitTypeEnabled(boolean value) {
        this.splitTypeEnabled = value;
    }

    String splitValue() {
        return this.splitValue;
    }

    void splitValue(String value) {
        this.splitValue = value;
    }

    boolean splitValueEnabled() {
        return this.splitValueEnabled;
    }

    void splitValueEnabled(boolean value) {
        this.splitValueEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

