/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.converttoimage;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.converttoimage.ConvertToImageNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ConvertToImageNodeDialog
extends NodeDialogPane {
    private final ConvertToImageNodeSettings nodeSettings = new ConvertToImageNodeSettings();
    private FilePicker fileInput;
    private JComboBox<String> imageFormat;
    private JCheckBox imageFormatEnabled;
    private JComboBox<String> singleOrMultiple;
    private JCheckBox singleOrMultipleEnabled;
    private JTextField pageNumbers;
    private JCheckBox pageNumbersEnabled;
    private JComboBox<String> colorType;
    private JCheckBox colorTypeEnabled;
    private JTextField dpi;
    private JCheckBox dpiEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ConvertToImageNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Image Format:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.imageFormatEnabled = new JCheckBox();
        this.imageFormatEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.imageFormatEnabled.setSelected(!this.imageFormatEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.imageFormatEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.imageFormat = new JComboBox<String>(ConvertToImageNodeSettings.IMAGE_FORMAT_VALUES);
        panel.add(this.imageFormat, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Single or Multiple:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.singleOrMultipleEnabled = new JCheckBox();
        this.singleOrMultipleEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.singleOrMultipleEnabled.setSelected(!this.singleOrMultipleEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.singleOrMultipleEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.singleOrMultiple = new JComboBox<String>(ConvertToImageNodeSettings.SINGLE_OR_MULTIPLE_VALUES);
        panel.add(this.singleOrMultiple, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Page Numbers:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.pageNumbersEnabled = new JCheckBox();
        this.pageNumbersEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.pageNumbersEnabled.setSelected(!this.pageNumbersEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pageNumbersEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pageNumbers = new JTextField(30);
        panel.add((Component)this.pageNumbers, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Color Type:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.colorTypeEnabled = new JCheckBox();
        this.colorTypeEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.colorTypeEnabled.setSelected(!this.colorTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.colorTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.colorType = new JComboBox<String>(ConvertToImageNodeSettings.COLOR_TYPE_VALUES);
        panel.add(this.colorType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Dpi:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        this.dpiEnabled = new JCheckBox();
        this.dpiEnabled.addActionListener(e -> this.updateComponents());
        label5.addActionListener(e -> {
            this.dpiEnabled.setSelected(!this.dpiEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.dpiEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.dpi = new JTextField(30);
        panel.add((Component)this.dpi, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ConvertToImageNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.imageFormat.setEnabled(this.imageFormatEnabled.isSelected());
        this.singleOrMultiple.setEnabled(this.singleOrMultipleEnabled.isSelected());
        this.pageNumbers.setEnabled(this.pageNumbersEnabled.isSelected());
        this.colorType.setEnabled(this.colorTypeEnabled.isSelected());
        this.dpi.setEnabled(this.dpiEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.imageFormat((String)this.imageFormat.getSelectedItem());
        this.nodeSettings.imageFormatEnabled(this.imageFormatEnabled.isSelected());
        this.nodeSettings.singleOrMultiple((String)this.singleOrMultiple.getSelectedItem());
        this.nodeSettings.singleOrMultipleEnabled(this.singleOrMultipleEnabled.isSelected());
        this.nodeSettings.pageNumbers(this.pageNumbers.getText());
        this.nodeSettings.pageNumbersEnabled(this.pageNumbersEnabled.isSelected());
        this.nodeSettings.colorType((String)this.colorType.getSelectedItem());
        this.nodeSettings.colorTypeEnabled(this.colorTypeEnabled.isSelected());
        this.nodeSettings.dpi(this.dpi.getText());
        this.nodeSettings.dpiEnabled(this.dpiEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.imageFormat.setSelectedItem(this.nodeSettings.imageFormat());
        this.imageFormatEnabled.setSelected(this.nodeSettings.imageFormatEnabled());
        this.singleOrMultiple.setSelectedItem(this.nodeSettings.singleOrMultiple());
        this.singleOrMultipleEnabled.setSelected(this.nodeSettings.singleOrMultipleEnabled());
        this.pageNumbers.setText(this.nodeSettings.pageNumbers());
        this.pageNumbersEnabled.setSelected(this.nodeSettings.pageNumbersEnabled());
        this.colorType.setSelectedItem(this.nodeSettings.colorType());
        this.colorTypeEnabled.setSelected(this.nodeSettings.colorTypeEnabled());
        this.dpi.setText(this.nodeSettings.dpi());
        this.dpiEnabled.setSelected(this.nodeSettings.dpiEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

