/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.converttopdf;

import com.nodepit.nodes.stirlingpdf.v1.ArrayInput;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.converttopdf.ConvertToPdfNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ConvertToPdfNodeDialog
extends NodeDialogPane {
    private final ConvertToPdfNodeSettings nodeSettings = new ConvertToPdfNodeSettings();
    private ArrayInput fileInput;
    private JComboBox<String> fitOption;
    private JCheckBox fitOptionEnabled;
    private JComboBox<String> colorType;
    private JCheckBox colorTypeEnabled;
    private JCheckBox autoRotate;
    private JCheckBox autoRotateEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ConvertToPdfNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = ArrayInput.filePickers();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Fit Option:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.fitOptionEnabled = new JCheckBox();
        this.fitOptionEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.fitOptionEnabled.setSelected(!this.fitOptionEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.fitOptionEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fitOption = new JComboBox<String>(ConvertToPdfNodeSettings.FIT_OPTION_VALUES);
        panel.add(this.fitOption, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Color Type:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.colorTypeEnabled = new JCheckBox();
        this.colorTypeEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.colorTypeEnabled.setSelected(!this.colorTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.colorTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.colorType = new JComboBox<String>(ConvertToPdfNodeSettings.COLOR_TYPE_VALUES);
        panel.add(this.colorType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Auto Rotate:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.autoRotateEnabled = new JCheckBox();
        this.autoRotateEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.autoRotateEnabled.setSelected(!this.autoRotateEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.autoRotateEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.autoRotate = new JCheckBox("true");
        panel.add((Component)this.autoRotate, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ConvertToPdfNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.fitOption.setEnabled(this.fitOptionEnabled.isSelected());
        this.colorType.setEnabled(this.colorTypeEnabled.isSelected());
        this.autoRotate.setEnabled(this.autoRotateEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getValues());
        this.nodeSettings.fitOption((String)this.fitOption.getSelectedItem());
        this.nodeSettings.fitOptionEnabled(this.fitOptionEnabled.isSelected());
        this.nodeSettings.colorType((String)this.colorType.getSelectedItem());
        this.nodeSettings.colorTypeEnabled(this.colorTypeEnabled.isSelected());
        this.nodeSettings.autoRotate(this.autoRotate.isSelected());
        this.nodeSettings.autoRotateEnabled(this.autoRotateEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setValues(this.nodeSettings.fileInput());
        this.fitOption.setSelectedItem(this.nodeSettings.fitOption());
        this.fitOptionEnabled.setSelected(this.nodeSettings.fitOptionEnabled());
        this.colorType.setSelectedItem(this.nodeSettings.colorType());
        this.colorTypeEnabled.setSelected(this.nodeSettings.colorTypeEnabled());
        this.autoRotate.setSelected(this.nodeSettings.autoRotate());
        this.autoRotateEnabled.setSelected(this.nodeSettings.autoRotateEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

