/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.converttopdf;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ConvertToPdfNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String[] FILE_INPUT_DEFAULT_VALUE = new String[1];
    private String[] fileInput = FILE_INPUT_DEFAULT_VALUE;
    static final String[] FIT_OPTION_VALUES = new String[]{"fillPage", "fitDocumentToImage", "maintainAspectRatio"};
    private static final String FIT_OPTION_KEY = "fitOption";
    private static final String FIT_OPTION_DEFAULT_VALUE = FIT_OPTION_VALUES[0];
    private String fitOption = FIT_OPTION_DEFAULT_VALUE;
    private static final String FIT_OPTION_ENABLED_KEY = "fitOptionEnabled";
    private boolean fitOptionEnabled = false;
    static final String[] COLOR_TYPE_VALUES = new String[]{"color", "greyscale", "blackwhite"};
    private static final String COLOR_TYPE_KEY = "colorType";
    private static final String COLOR_TYPE_DEFAULT_VALUE = COLOR_TYPE_VALUES[0];
    private String colorType = COLOR_TYPE_DEFAULT_VALUE;
    private static final String COLOR_TYPE_ENABLED_KEY = "colorTypeEnabled";
    private boolean colorTypeEnabled = false;
    private static final String AUTO_ROTATE_KEY = "autoRotate";
    private static final boolean AUTO_ROTATE_DEFAULT_VALUE = false;
    private boolean autoRotate = false;
    private static final String AUTO_ROTATE_ENABLED_KEY = "autoRotateEnabled";
    private boolean autoRotateEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ConvertToPdfNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addStringArray(FILE_INPUT_KEY, this.fileInput);
        settings.addString(FIT_OPTION_KEY, this.fitOption);
        settings.addBoolean(FIT_OPTION_ENABLED_KEY, this.fitOptionEnabled);
        settings.addString(COLOR_TYPE_KEY, this.colorType);
        settings.addBoolean(COLOR_TYPE_ENABLED_KEY, this.colorTypeEnabled);
        settings.addBoolean(AUTO_ROTATE_KEY, this.autoRotate);
        settings.addBoolean(AUTO_ROTATE_ENABLED_KEY, this.autoRotateEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getStringArray(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.fitOption = settings.getString(FIT_OPTION_KEY, FIT_OPTION_DEFAULT_VALUE);
        this.fitOptionEnabled = settings.getBoolean(FIT_OPTION_ENABLED_KEY, false);
        this.colorType = settings.getString(COLOR_TYPE_KEY, COLOR_TYPE_DEFAULT_VALUE);
        this.colorTypeEnabled = settings.getBoolean(COLOR_TYPE_ENABLED_KEY, false);
        this.autoRotate = settings.getBoolean(AUTO_ROTATE_KEY, false);
        this.autoRotateEnabled = settings.getBoolean(AUTO_ROTATE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.length == 0) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String[] fileInput() {
        return this.fileInput;
    }

    void fileInput(String[] value) {
        this.fileInput = value;
    }

    String fitOption() {
        return this.fitOption;
    }

    void fitOption(String value) {
        this.fitOption = value;
    }

    boolean fitOptionEnabled() {
        return this.fitOptionEnabled;
    }

    void fitOptionEnabled(boolean value) {
        this.fitOptionEnabled = value;
    }

    String colorType() {
        return this.colorType;
    }

    void colorType(String value) {
        this.colorType = value;
    }

    boolean colorTypeEnabled() {
        return this.colorTypeEnabled;
    }

    void colorTypeEnabled(boolean value) {
        this.colorTypeEnabled = value;
    }

    boolean autoRotate() {
        return this.autoRotate;
    }

    void autoRotate(boolean value) {
        this.autoRotate = value;
    }

    boolean autoRotateEnabled() {
        return this.autoRotateEnabled;
    }

    void autoRotateEnabled(boolean value) {
        this.autoRotateEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

