/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.extractimages;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.extractimages.ExtractImagesNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ExtractImagesNodeDialog
extends NodeDialogPane {
    private final ExtractImagesNodeSettings nodeSettings = new ExtractImagesNodeSettings();
    private FilePicker fileInput;
    private JComboBox<String> format;
    private JCheckBox formatEnabled;
    private JCheckBox allowDuplicates;
    private JCheckBox allowDuplicatesEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ExtractImagesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Format:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.formatEnabled = new JCheckBox();
        this.formatEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.formatEnabled.setSelected(!this.formatEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.formatEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.format = new JComboBox<String>(ExtractImagesNodeSettings.FORMAT_VALUES);
        panel.add(this.format, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Allow Duplicates:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.allowDuplicatesEnabled = new JCheckBox();
        this.allowDuplicatesEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.allowDuplicatesEnabled.setSelected(!this.allowDuplicatesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.allowDuplicatesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.allowDuplicates = new JCheckBox("true");
        panel.add((Component)this.allowDuplicates, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ExtractImagesNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.format.setEnabled(this.formatEnabled.isSelected());
        this.allowDuplicates.setEnabled(this.allowDuplicatesEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.format((String)this.format.getSelectedItem());
        this.nodeSettings.formatEnabled(this.formatEnabled.isSelected());
        this.nodeSettings.allowDuplicates(this.allowDuplicates.isSelected());
        this.nodeSettings.allowDuplicatesEnabled(this.allowDuplicatesEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.format.setSelectedItem(this.nodeSettings.format());
        this.formatEnabled.setSelected(this.nodeSettings.formatEnabled());
        this.allowDuplicates.setSelected(this.nodeSettings.allowDuplicates());
        this.allowDuplicatesEnabled.setSelected(this.nodeSettings.allowDuplicatesEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

