/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.extractimagescans;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ExtractImageScansNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String ANGLE_THRESHOLD_KEY = "angleThreshold";
    static final Integer ANGLE_THRESHOLD_DEFAULT_VALUE = 5;
    static final Integer ANGLE_THRESHOLD_MINIMUM_VALUE = null;
    static final Integer ANGLE_THRESHOLD_MAXIMUM_VALUE = null;
    private int angleThreshold = ANGLE_THRESHOLD_DEFAULT_VALUE;
    private static final String ANGLE_THRESHOLD_ENABLED_KEY = "angleThresholdEnabled";
    private boolean angleThresholdEnabled = false;
    private static final String TOLERANCE_KEY = "tolerance";
    static final Integer TOLERANCE_DEFAULT_VALUE = 20;
    static final Integer TOLERANCE_MINIMUM_VALUE = null;
    static final Integer TOLERANCE_MAXIMUM_VALUE = null;
    private int tolerance = TOLERANCE_DEFAULT_VALUE;
    private static final String TOLERANCE_ENABLED_KEY = "toleranceEnabled";
    private boolean toleranceEnabled = false;
    private static final String MIN_AREA_KEY = "minArea";
    static final Integer MIN_AREA_DEFAULT_VALUE = 8000;
    static final Integer MIN_AREA_MINIMUM_VALUE = null;
    static final Integer MIN_AREA_MAXIMUM_VALUE = null;
    private int minArea = MIN_AREA_DEFAULT_VALUE;
    private static final String MIN_AREA_ENABLED_KEY = "minAreaEnabled";
    private boolean minAreaEnabled = false;
    private static final String MIN_CONTOUR_AREA_KEY = "minContourArea";
    static final Integer MIN_CONTOUR_AREA_DEFAULT_VALUE = 500;
    static final Integer MIN_CONTOUR_AREA_MINIMUM_VALUE = null;
    static final Integer MIN_CONTOUR_AREA_MAXIMUM_VALUE = null;
    private int minContourArea = MIN_CONTOUR_AREA_DEFAULT_VALUE;
    private static final String MIN_CONTOUR_AREA_ENABLED_KEY = "minContourAreaEnabled";
    private boolean minContourAreaEnabled = false;
    private static final String BORDER_SIZE_KEY = "borderSize";
    static final Integer BORDER_SIZE_DEFAULT_VALUE = 1;
    static final Integer BORDER_SIZE_MINIMUM_VALUE = null;
    static final Integer BORDER_SIZE_MAXIMUM_VALUE = null;
    private int borderSize = BORDER_SIZE_DEFAULT_VALUE;
    private static final String BORDER_SIZE_ENABLED_KEY = "borderSizeEnabled";
    private boolean borderSizeEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ExtractImageScansNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addInt(ANGLE_THRESHOLD_KEY, this.angleThreshold);
        settings.addBoolean(ANGLE_THRESHOLD_ENABLED_KEY, this.angleThresholdEnabled);
        settings.addInt(TOLERANCE_KEY, this.tolerance);
        settings.addBoolean(TOLERANCE_ENABLED_KEY, this.toleranceEnabled);
        settings.addInt(MIN_AREA_KEY, this.minArea);
        settings.addBoolean(MIN_AREA_ENABLED_KEY, this.minAreaEnabled);
        settings.addInt(MIN_CONTOUR_AREA_KEY, this.minContourArea);
        settings.addBoolean(MIN_CONTOUR_AREA_ENABLED_KEY, this.minContourAreaEnabled);
        settings.addInt(BORDER_SIZE_KEY, this.borderSize);
        settings.addBoolean(BORDER_SIZE_ENABLED_KEY, this.borderSizeEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.angleThreshold = settings.getInt(ANGLE_THRESHOLD_KEY, ANGLE_THRESHOLD_DEFAULT_VALUE.intValue());
        this.angleThresholdEnabled = settings.getBoolean(ANGLE_THRESHOLD_ENABLED_KEY, false);
        this.tolerance = settings.getInt(TOLERANCE_KEY, TOLERANCE_DEFAULT_VALUE.intValue());
        this.toleranceEnabled = settings.getBoolean(TOLERANCE_ENABLED_KEY, false);
        this.minArea = settings.getInt(MIN_AREA_KEY, MIN_AREA_DEFAULT_VALUE.intValue());
        this.minAreaEnabled = settings.getBoolean(MIN_AREA_ENABLED_KEY, false);
        this.minContourArea = settings.getInt(MIN_CONTOUR_AREA_KEY, MIN_CONTOUR_AREA_DEFAULT_VALUE.intValue());
        this.minContourAreaEnabled = settings.getBoolean(MIN_CONTOUR_AREA_ENABLED_KEY, false);
        this.borderSize = settings.getInt(BORDER_SIZE_KEY, BORDER_SIZE_DEFAULT_VALUE.intValue());
        this.borderSizeEnabled = settings.getBoolean(BORDER_SIZE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    int angleThreshold() {
        return this.angleThreshold;
    }

    void angleThreshold(int value) {
        this.angleThreshold = value;
    }

    boolean angleThresholdEnabled() {
        return this.angleThresholdEnabled;
    }

    void angleThresholdEnabled(boolean value) {
        this.angleThresholdEnabled = value;
    }

    int tolerance() {
        return this.tolerance;
    }

    void tolerance(int value) {
        this.tolerance = value;
    }

    boolean toleranceEnabled() {
        return this.toleranceEnabled;
    }

    void toleranceEnabled(boolean value) {
        this.toleranceEnabled = value;
    }

    int minArea() {
        return this.minArea;
    }

    void minArea(int value) {
        this.minArea = value;
    }

    boolean minAreaEnabled() {
        return this.minAreaEnabled;
    }

    void minAreaEnabled(boolean value) {
        this.minAreaEnabled = value;
    }

    int minContourArea() {
        return this.minContourArea;
    }

    void minContourArea(int value) {
        this.minContourArea = value;
    }

    boolean minContourAreaEnabled() {
        return this.minContourAreaEnabled;
    }

    void minContourAreaEnabled(boolean value) {
        this.minContourAreaEnabled = value;
    }

    int borderSize() {
        return this.borderSize;
    }

    void borderSize(int value) {
        this.borderSize = value;
    }

    boolean borderSizeEnabled() {
        return this.borderSizeEnabled;
    }

    void borderSizeEnabled(boolean value) {
        this.borderSizeEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

