/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.getuniquepageloads;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetUniquePageLoadsNodeSettings {
    private static final String ENDPOINT_KEY = "endpoint";
    private static final String ENDPOINT_DEFAULT_VALUE = null;
    private String endpoint = ENDPOINT_DEFAULT_VALUE;
    private static final String ENDPOINT_ENABLED_KEY = "endpointEnabled";
    private boolean endpointEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetUniquePageLoadsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ENDPOINT_KEY, this.endpoint);
        settings.addBoolean(ENDPOINT_ENABLED_KEY, this.endpointEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.endpoint = settings.getString(ENDPOINT_KEY, ENDPOINT_DEFAULT_VALUE);
        this.endpointEnabled = settings.getBoolean(ENDPOINT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String endpoint() {
        return this.endpoint;
    }

    void endpoint(String value) {
        this.endpoint = value;
    }

    boolean endpointEnabled() {
        return this.endpointEnabled;
    }

    void endpointEnabled(boolean value) {
        this.endpointEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

