/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.mergemultiplepagesintoone;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.mergemultiplepagesintoone.MergeMultiplePagesIntoOneNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class MergeMultiplePagesIntoOneNodeDialog
extends NodeDialogPane {
    private final MergeMultiplePagesIntoOneNodeSettings nodeSettings = new MergeMultiplePagesIntoOneNodeSettings();
    private FilePicker fileInput;
    private JSpinner pagesPerSheet;
    private JCheckBox pagesPerSheetEnabled;
    private JCheckBox addBorder;
    private JCheckBox addBorderEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    MergeMultiplePagesIntoOneNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Pages Per Sheet:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.pagesPerSheetEnabled = new JCheckBox();
        this.pagesPerSheetEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.pagesPerSheetEnabled.setSelected(!this.pagesPerSheetEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pagesPerSheetEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pagesPerSheet = new JSpinner(new SpinnerNumberModel(MergeMultiplePagesIntoOneNodeSettings.PAGES_PER_SHEET_DEFAULT_VALUE, MergeMultiplePagesIntoOneNodeSettings.PAGES_PER_SHEET_MINIMUM_VALUE, MergeMultiplePagesIntoOneNodeSettings.PAGES_PER_SHEET_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.pagesPerSheet, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Add Border:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.addBorderEnabled = new JCheckBox();
        this.addBorderEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.addBorderEnabled.setSelected(!this.addBorderEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.addBorderEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.addBorder = new JCheckBox("true");
        panel.add((Component)this.addBorder, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(MergeMultiplePagesIntoOneNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.pagesPerSheet.setEnabled(this.pagesPerSheetEnabled.isSelected());
        this.addBorder.setEnabled(this.addBorderEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.pagesPerSheet((Integer)this.pagesPerSheet.getValue());
        this.nodeSettings.pagesPerSheetEnabled(this.pagesPerSheetEnabled.isSelected());
        this.nodeSettings.addBorder(this.addBorder.isSelected());
        this.nodeSettings.addBorderEnabled(this.addBorderEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.pagesPerSheet.setValue(this.nodeSettings.pagesPerSheet());
        this.pagesPerSheetEnabled.setSelected(this.nodeSettings.pagesPerSheetEnabled());
        this.addBorder.setSelected(this.nodeSettings.addBorder());
        this.addBorderEnabled.setSelected(this.nodeSettings.addBorderEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

