/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.mergepdfs;

import com.nodepit.nodes.stirlingpdf.v1.ArrayInput;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.mergepdfs.MergePdfsNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class MergePdfsNodeDialog
extends NodeDialogPane {
    private final MergePdfsNodeSettings nodeSettings = new MergePdfsNodeSettings();
    private ArrayInput fileInput;
    private JComboBox<String> sortType;
    private JCheckBox sortTypeEnabled;
    private JCheckBox removeCertSign;
    private JCheckBox removeCertSignEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    MergePdfsNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = ArrayInput.filePickers();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Sort Type:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.sortTypeEnabled = new JCheckBox();
        this.sortTypeEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.sortTypeEnabled.setSelected(!this.sortTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.sortTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.sortType = new JComboBox<String>(MergePdfsNodeSettings.SORT_TYPE_VALUES);
        panel.add(this.sortType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Remove Cert Sign:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeCertSignEnabled = new JCheckBox();
        this.removeCertSignEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.removeCertSignEnabled.setSelected(!this.removeCertSignEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeCertSignEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeCertSign = new JCheckBox("true");
        panel.add((Component)this.removeCertSign, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(MergePdfsNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.sortType.setEnabled(this.sortTypeEnabled.isSelected());
        this.removeCertSign.setEnabled(this.removeCertSignEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getValues());
        this.nodeSettings.sortType((String)this.sortType.getSelectedItem());
        this.nodeSettings.sortTypeEnabled(this.sortTypeEnabled.isSelected());
        this.nodeSettings.removeCertSign(this.removeCertSign.isSelected());
        this.nodeSettings.removeCertSignEnabled(this.removeCertSignEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setValues(this.nodeSettings.fileInput());
        this.sortType.setSelectedItem(this.nodeSettings.sortType());
        this.sortTypeEnabled.setSelected(this.nodeSettings.sortTypeEnabled());
        this.removeCertSign.setSelected(this.nodeSettings.removeCertSign());
        this.removeCertSignEnabled.setSelected(this.nodeSettings.removeCertSignEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

