/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.optimizepdf;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.optimizepdf.OptimizePdfNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class OptimizePdfNodeDialog
extends NodeDialogPane {
    private final OptimizePdfNodeSettings nodeSettings = new OptimizePdfNodeSettings();
    private FilePicker fileInput;
    private JSpinner optimizeLevel;
    private JCheckBox optimizeLevelEnabled;
    private JTextField expectedOutputSize;
    private JCheckBox expectedOutputSizeEnabled;
    private JCheckBox linearize;
    private JCheckBox linearizeEnabled;
    private JCheckBox normalize;
    private JCheckBox normalizeEnabled;
    private JCheckBox grayscale;
    private JCheckBox grayscaleEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    OptimizePdfNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Optimize Level:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.optimizeLevelEnabled = new JCheckBox();
        this.optimizeLevelEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.optimizeLevelEnabled.setSelected(!this.optimizeLevelEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.optimizeLevelEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.optimizeLevel = new JSpinner(new SpinnerNumberModel(OptimizePdfNodeSettings.OPTIMIZE_LEVEL_DEFAULT_VALUE, OptimizePdfNodeSettings.OPTIMIZE_LEVEL_MINIMUM_VALUE, OptimizePdfNodeSettings.OPTIMIZE_LEVEL_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.optimizeLevel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Expected Output Size:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.expectedOutputSizeEnabled = new JCheckBox();
        this.expectedOutputSizeEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.expectedOutputSizeEnabled.setSelected(!this.expectedOutputSizeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.expectedOutputSizeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.expectedOutputSize = new JTextField(30);
        panel.add((Component)this.expectedOutputSize, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Linearize:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.linearizeEnabled = new JCheckBox();
        this.linearizeEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.linearizeEnabled.setSelected(!this.linearizeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.linearizeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.linearize = new JCheckBox("true");
        panel.add((Component)this.linearize, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Normalize:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.normalizeEnabled = new JCheckBox();
        this.normalizeEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.normalizeEnabled.setSelected(!this.normalizeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.normalizeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.normalize = new JCheckBox("true");
        panel.add((Component)this.normalize, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Grayscale:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        this.grayscaleEnabled = new JCheckBox();
        this.grayscaleEnabled.addActionListener(e -> this.updateComponents());
        label5.addActionListener(e -> {
            this.grayscaleEnabled.setSelected(!this.grayscaleEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.grayscaleEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.grayscale = new JCheckBox("true");
        panel.add((Component)this.grayscale, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(OptimizePdfNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.optimizeLevel.setEnabled(this.optimizeLevelEnabled.isSelected());
        this.expectedOutputSize.setEnabled(this.expectedOutputSizeEnabled.isSelected());
        this.linearize.setEnabled(this.linearizeEnabled.isSelected());
        this.normalize.setEnabled(this.normalizeEnabled.isSelected());
        this.grayscale.setEnabled(this.grayscaleEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.optimizeLevel((Integer)this.optimizeLevel.getValue());
        this.nodeSettings.optimizeLevelEnabled(this.optimizeLevelEnabled.isSelected());
        this.nodeSettings.expectedOutputSize(this.expectedOutputSize.getText());
        this.nodeSettings.expectedOutputSizeEnabled(this.expectedOutputSizeEnabled.isSelected());
        this.nodeSettings.linearize(this.linearize.isSelected());
        this.nodeSettings.linearizeEnabled(this.linearizeEnabled.isSelected());
        this.nodeSettings.normalize(this.normalize.isSelected());
        this.nodeSettings.normalizeEnabled(this.normalizeEnabled.isSelected());
        this.nodeSettings.grayscale(this.grayscale.isSelected());
        this.nodeSettings.grayscaleEnabled(this.grayscaleEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.optimizeLevel.setValue(this.nodeSettings.optimizeLevel());
        this.optimizeLevelEnabled.setSelected(this.nodeSettings.optimizeLevelEnabled());
        this.expectedOutputSize.setText(this.nodeSettings.expectedOutputSize());
        this.expectedOutputSizeEnabled.setSelected(this.nodeSettings.expectedOutputSizeEnabled());
        this.linearize.setSelected(this.nodeSettings.linearize());
        this.linearizeEnabled.setSelected(this.nodeSettings.linearizeEnabled());
        this.normalize.setSelected(this.nodeSettings.normalize());
        this.normalizeEnabled.setSelected(this.nodeSettings.normalizeEnabled());
        this.grayscale.setSelected(this.nodeSettings.grayscale());
        this.grayscaleEnabled.setSelected(this.nodeSettings.grayscaleEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

