/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.overlaypdfs;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class OverlayPdfsNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String OVERLAY_FILES_KEY = "overlayFiles";
    private static final String[] OVERLAY_FILES_DEFAULT_VALUE = new String[1];
    private String[] overlayFiles = OVERLAY_FILES_DEFAULT_VALUE;
    private static final String OVERLAY_FILES_ENABLED_KEY = "overlayFilesEnabled";
    private boolean overlayFilesEnabled = false;
    private static final String OVERLAY_MODE_KEY = "overlayMode";
    private static final String OVERLAY_MODE_DEFAULT_VALUE = null;
    private String overlayMode = OVERLAY_MODE_DEFAULT_VALUE;
    private static final String COUNTS_KEY = "counts";
    private static final String[] COUNTS_DEFAULT_VALUE = new String[1];
    private String[] counts = COUNTS_DEFAULT_VALUE;
    private static final String COUNTS_ENABLED_KEY = "countsEnabled";
    private boolean countsEnabled = false;
    private static final String OVERLAY_POSITION_KEY = "overlayPosition";
    static final Integer OVERLAY_POSITION_DEFAULT_VALUE = 0;
    static final Integer OVERLAY_POSITION_MINIMUM_VALUE = null;
    static final Integer OVERLAY_POSITION_MAXIMUM_VALUE = null;
    private int overlayPosition = OVERLAY_POSITION_DEFAULT_VALUE;
    private static final String OVERLAY_POSITION_ENABLED_KEY = "overlayPositionEnabled";
    private boolean overlayPositionEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    OverlayPdfsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addStringArray(OVERLAY_FILES_KEY, this.overlayFiles);
        settings.addBoolean(OVERLAY_FILES_ENABLED_KEY, this.overlayFilesEnabled);
        settings.addString(OVERLAY_MODE_KEY, this.overlayMode);
        settings.addStringArray(COUNTS_KEY, this.counts);
        settings.addBoolean(COUNTS_ENABLED_KEY, this.countsEnabled);
        settings.addInt(OVERLAY_POSITION_KEY, this.overlayPosition);
        settings.addBoolean(OVERLAY_POSITION_ENABLED_KEY, this.overlayPositionEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.overlayFiles = settings.getStringArray(OVERLAY_FILES_KEY, OVERLAY_FILES_DEFAULT_VALUE);
        this.overlayFilesEnabled = settings.getBoolean(OVERLAY_FILES_ENABLED_KEY, false);
        this.overlayMode = settings.getString(OVERLAY_MODE_KEY, OVERLAY_MODE_DEFAULT_VALUE);
        this.counts = settings.getStringArray(COUNTS_KEY, COUNTS_DEFAULT_VALUE);
        this.countsEnabled = settings.getBoolean(COUNTS_ENABLED_KEY, false);
        this.overlayPosition = settings.getInt(OVERLAY_POSITION_KEY, OVERLAY_POSITION_DEFAULT_VALUE.intValue());
        this.overlayPositionEnabled = settings.getBoolean(OVERLAY_POSITION_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.overlayMode == null || this.overlayMode.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOverlay Mode\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String[] overlayFiles() {
        return this.overlayFiles;
    }

    void overlayFiles(String[] value) {
        this.overlayFiles = value;
    }

    boolean overlayFilesEnabled() {
        return this.overlayFilesEnabled;
    }

    void overlayFilesEnabled(boolean value) {
        this.overlayFilesEnabled = value;
    }

    String overlayMode() {
        return this.overlayMode;
    }

    void overlayMode(String value) {
        this.overlayMode = value;
    }

    String[] counts() {
        return this.counts;
    }

    void counts(String[] value) {
        this.counts = value;
    }

    boolean countsEnabled() {
        return this.countsEnabled;
    }

    void countsEnabled(boolean value) {
        this.countsEnabled = value;
    }

    int overlayPosition() {
        return this.overlayPosition;
    }

    void overlayPosition(int value) {
        this.overlayPosition = value;
    }

    boolean overlayPositionEnabled() {
        return this.overlayPositionEnabled;
    }

    void overlayPositionEnabled(boolean value) {
        this.overlayPositionEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

