/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.pagecount;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.pagecount.PageCountNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class PageCountNodeDialog
extends NodeDialogPane {
    private final PageCountNodeSettings nodeSettings = new PageCountNodeSettings();
    private FilePicker fileInput;
    private JComboBox<String> comparator;
    private JCheckBox comparatorEnabled;
    private JTextField pageCount;
    private JCheckBox pageCountEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    PageCountNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Comparator:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.comparatorEnabled = new JCheckBox();
        this.comparatorEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.comparatorEnabled.setSelected(!this.comparatorEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.comparatorEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.comparator = new JComboBox<String>(PageCountNodeSettings.COMPARATOR_VALUES);
        panel.add(this.comparator, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Page Count:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.pageCountEnabled = new JCheckBox();
        this.pageCountEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.pageCountEnabled.setSelected(!this.pageCountEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pageCountEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pageCount = new JTextField(30);
        panel.add((Component)this.pageCount, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(PageCountNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.comparator.setEnabled(this.comparatorEnabled.isSelected());
        this.pageCount.setEnabled(this.pageCountEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.comparator((String)this.comparator.getSelectedItem());
        this.nodeSettings.comparatorEnabled(this.comparatorEnabled.isSelected());
        this.nodeSettings.pageCount(this.pageCount.getText());
        this.nodeSettings.pageCountEnabled(this.pageCountEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.comparator.setSelectedItem(this.nodeSettings.comparator());
        this.comparatorEnabled.setSelected(this.nodeSettings.comparatorEnabled());
        this.pageCount.setText(this.nodeSettings.pageCount());
        this.pageCountEnabled.setSelected(this.nodeSettings.pageCountEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

