/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.processfiletopdf;

import com.nodepit.nodes.stirlingpdf.v1.CountingRequestBody;
import com.nodepit.nodes.stirlingpdf.v1.Utils;
import com.nodepit.nodes.stirlingpdf.v1.operation.processfiletopdf.ProcessFileToPDFNodeSettings;
import com.nodepit.nodes.stirlingpdf.v1.port.ConfigPortObjectSpec;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class ProcessFileToPDFNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ProcessFileToPDFNodeModel.class);
    private final ProcessFileToPDFNodeSettings nodeSettings = new ProcessFileToPDFNodeSettings();

    protected ProcessFileToPDFNodeModel(PortType[] inPorts, PortType[] outPorts) {
        super(inPorts, outPorts);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        ConfigPortObjectSpec configPortObjectSpec = this.getNrInPorts() == 0 ? ConfigPortObjectSpec.DEFAULT : (ConfigPortObjectSpec)inObjects[0].getSpec();
        String serverUrl = configPortObjectSpec.getUrl();
        String path = "/api/v1/convert/file/pdf";
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(String.valueOf(serverUrl) + path)).newBuilder();
        HttpUrl url = urlBuilder.build();
        RequestBody requestBody = RequestBody.create((byte[])new byte[0], null);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        bodyBuilder.addFormDataPart("fileInput", Utils.getFilename(this.nodeSettings.fileInput()), Utils.getRequestBody(this.nodeSettings.fileInput()));
        requestBody = bodyBuilder.build();
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        configPortObjectSpec.addInterceptors(clientBuilder);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(message -> LOGGER.debug((Object)message));
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        clientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
        OkHttpClient client = clientBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        exec.setProgress("Sending request");
        ExecutionMonitor uploadProgress = exec.createSubProgress(0.5);
        requestBody = new CountingRequestBody(requestBody, (bytesWritten, contentLength) -> uploadProgress.setProgress((double)bytesWritten / (double)contentLength, () -> String.valueOf(Utils.humanReadableByteCountSI(bytesWritten)) + " / " + Utils.humanReadableByteCountSI(contentLength)));
        requestBuilder.method("POST", requestBody);
        requestBuilder.header("accept", this.getResponseType());
        Request request = requestBuilder.build();
        Call call = client.newCall(request);
        exec.setProgress("Receiving response");
        Response response = call.execute();
        if (!response.isSuccessful()) {
            String message2 = "Encountered HTTP status " + response.code();
            String bodyString = response.body().string();
            if (bodyString != null && !bodyString.isEmpty()) {
                message2 = String.valueOf(message2) + ": " + bodyString;
            }
            throw new IOException(message2);
        }
        BufferedDataTable responseTable = this.nodeSettings.getResponseMapper().getTable(exec, response, this.getResponseType());
        if (this.getNrInPorts() == 0) {
            return new PortObject[]{responseTable};
        }
        return new PortObject[]{responseTable, inObjects[0]};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        try {
            this.nodeSettings.validateSettings();
        }
        catch (InvalidSettingsException invalidSettingsException) {
            throw new InvalidSettingsException("Missing configuration \u2013 please configure the node.");
        }
        DataTableSpec responseSpec = this.nodeSettings.getResponseMapper().getSpec(this.getResponseType());
        if (this.getNrInPorts() == 0) {
            return new PortObjectSpec[]{responseSpec};
        }
        return new PortObjectSpec[]{responseSpec, inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private String getResponseType() {
        return "application/pdf";
    }
}

