/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.processpdfwithocr;

import com.nodepit.nodes.stirlingpdf.v1.ArrayInput;
import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.processpdfwithocr.ProcessPdfWithOCRNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ProcessPdfWithOCRNodeDialog
extends NodeDialogPane {
    private final ProcessPdfWithOCRNodeSettings nodeSettings = new ProcessPdfWithOCRNodeSettings();
    private FilePicker fileInput;
    private ArrayInput languages;
    private JCheckBox languagesEnabled;
    private JComboBox<String> ocrType;
    private JCheckBox ocrTypeEnabled;
    private JComboBox<String> ocrRenderType;
    private JCheckBox ocrRenderTypeEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    ProcessPdfWithOCRNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Languages:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.languagesEnabled = new JCheckBox();
        this.languagesEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.languagesEnabled.setSelected(!this.languagesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.languagesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.languages = ArrayInput.textFields();
        panel.add((Component)this.languages, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Ocr Type:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.ocrTypeEnabled = new JCheckBox();
        this.ocrTypeEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.ocrTypeEnabled.setSelected(!this.ocrTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.ocrTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.ocrType = new JComboBox<String>(ProcessPdfWithOCRNodeSettings.OCR_TYPE_VALUES);
        panel.add(this.ocrType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Ocr Render Type:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.ocrRenderTypeEnabled = new JCheckBox();
        this.ocrRenderTypeEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.ocrRenderTypeEnabled.setSelected(!this.ocrRenderTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.ocrRenderTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.ocrRenderType = new JComboBox<String>(ProcessPdfWithOCRNodeSettings.OCR_RENDER_TYPE_VALUES);
        panel.add(this.ocrRenderType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ProcessPdfWithOCRNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.languages.setEnabled(this.languagesEnabled.isSelected());
        this.ocrType.setEnabled(this.ocrTypeEnabled.isSelected());
        this.ocrRenderType.setEnabled(this.ocrRenderTypeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.languages(this.languages.getValues());
        this.nodeSettings.languagesEnabled(this.languagesEnabled.isSelected());
        this.nodeSettings.ocrType((String)this.ocrType.getSelectedItem());
        this.nodeSettings.ocrTypeEnabled(this.ocrTypeEnabled.isSelected());
        this.nodeSettings.ocrRenderType((String)this.ocrRenderType.getSelectedItem());
        this.nodeSettings.ocrRenderTypeEnabled(this.ocrRenderTypeEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.languages.setValues(this.nodeSettings.languages());
        this.languagesEnabled.setSelected(this.nodeSettings.languagesEnabled());
        this.ocrType.setSelectedItem(this.nodeSettings.ocrType());
        this.ocrTypeEnabled.setSelected(this.nodeSettings.ocrTypeEnabled());
        this.ocrRenderType.setSelectedItem(this.nodeSettings.ocrRenderType());
        this.ocrRenderTypeEnabled.setSelected(this.nodeSettings.ocrRenderTypeEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

