/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.processpdfwithocr;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ProcessPdfWithOCRNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String LANGUAGES_KEY = "languages";
    private static final String[] LANGUAGES_DEFAULT_VALUE = new String[1];
    private String[] languages = LANGUAGES_DEFAULT_VALUE;
    private static final String LANGUAGES_ENABLED_KEY = "languagesEnabled";
    private boolean languagesEnabled = false;
    static final String[] OCR_TYPE_VALUES = new String[]{"skip-text", "force-ocr", "Normal"};
    private static final String OCR_TYPE_KEY = "ocrType";
    private static final String OCR_TYPE_DEFAULT_VALUE = OCR_TYPE_VALUES[0];
    private String ocrType = OCR_TYPE_DEFAULT_VALUE;
    private static final String OCR_TYPE_ENABLED_KEY = "ocrTypeEnabled";
    private boolean ocrTypeEnabled = false;
    static final String[] OCR_RENDER_TYPE_VALUES = new String[]{"hocr", "sandwich"};
    private static final String OCR_RENDER_TYPE_KEY = "ocrRenderType";
    private static final String OCR_RENDER_TYPE_DEFAULT_VALUE = "hocr";
    private String ocrRenderType = "hocr";
    private static final String OCR_RENDER_TYPE_ENABLED_KEY = "ocrRenderTypeEnabled";
    private boolean ocrRenderTypeEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ProcessPdfWithOCRNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addStringArray(LANGUAGES_KEY, this.languages);
        settings.addBoolean(LANGUAGES_ENABLED_KEY, this.languagesEnabled);
        settings.addString(OCR_TYPE_KEY, this.ocrType);
        settings.addBoolean(OCR_TYPE_ENABLED_KEY, this.ocrTypeEnabled);
        settings.addString(OCR_RENDER_TYPE_KEY, this.ocrRenderType);
        settings.addBoolean(OCR_RENDER_TYPE_ENABLED_KEY, this.ocrRenderTypeEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.languages = settings.getStringArray(LANGUAGES_KEY, LANGUAGES_DEFAULT_VALUE);
        this.languagesEnabled = settings.getBoolean(LANGUAGES_ENABLED_KEY, false);
        this.ocrType = settings.getString(OCR_TYPE_KEY, OCR_TYPE_DEFAULT_VALUE);
        this.ocrTypeEnabled = settings.getBoolean(OCR_TYPE_ENABLED_KEY, false);
        this.ocrRenderType = settings.getString(OCR_RENDER_TYPE_KEY, OCR_RENDER_TYPE_DEFAULT_VALUE);
        this.ocrRenderTypeEnabled = settings.getBoolean(OCR_RENDER_TYPE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    String[] languages() {
        return this.languages;
    }

    void languages(String[] value) {
        this.languages = value;
    }

    boolean languagesEnabled() {
        return this.languagesEnabled;
    }

    void languagesEnabled(boolean value) {
        this.languagesEnabled = value;
    }

    String ocrType() {
        return this.ocrType;
    }

    void ocrType(String value) {
        this.ocrType = value;
    }

    boolean ocrTypeEnabled() {
        return this.ocrTypeEnabled;
    }

    void ocrTypeEnabled(boolean value) {
        this.ocrTypeEnabled = value;
    }

    String ocrRenderType() {
        return this.ocrRenderType;
    }

    void ocrRenderType(String value) {
        this.ocrRenderType = value;
    }

    boolean ocrRenderTypeEnabled() {
        return this.ocrRenderTypeEnabled;
    }

    void ocrRenderTypeEnabled(boolean value) {
        this.ocrRenderTypeEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

