/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.rearrangepages;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.rearrangepages.RearrangePagesNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class RearrangePagesNodeDialog
extends NodeDialogPane {
    private final RearrangePagesNodeSettings nodeSettings = new RearrangePagesNodeSettings();
    private FilePicker fileInput;
    private JTextField pageNumbers;
    private JCheckBox pageNumbersEnabled;
    private JComboBox<String> customMode;
    private JCheckBox customModeEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    RearrangePagesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Page Numbers:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.pageNumbersEnabled = new JCheckBox();
        this.pageNumbersEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.pageNumbersEnabled.setSelected(!this.pageNumbersEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.pageNumbersEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.pageNumbers = new JTextField(30);
        panel.add((Component)this.pageNumbers, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Custom Mode:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.customModeEnabled = new JCheckBox();
        this.customModeEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.customModeEnabled.setSelected(!this.customModeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.customModeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.customMode = new JComboBox<String>(RearrangePagesNodeSettings.CUSTOM_MODE_VALUES);
        panel.add(this.customMode, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(RearrangePagesNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.pageNumbers.setEnabled(this.pageNumbersEnabled.isSelected());
        this.customMode.setEnabled(this.customModeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.pageNumbers(this.pageNumbers.getText());
        this.nodeSettings.pageNumbersEnabled(this.pageNumbersEnabled.isSelected());
        this.nodeSettings.customMode((String)this.customMode.getSelectedItem());
        this.nodeSettings.customModeEnabled(this.customModeEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.pageNumbers.setText(this.nodeSettings.pageNumbers());
        this.pageNumbersEnabled.setSelected(this.nodeSettings.pageNumbersEnabled());
        this.customMode.setSelectedItem(this.nodeSettings.customMode());
        this.customModeEnabled.setSelected(this.nodeSettings.customModeEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

