/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.removeblankpages;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.removeblankpages.RemoveBlankPagesNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class RemoveBlankPagesNodeDialog
extends NodeDialogPane {
    private final RemoveBlankPagesNodeSettings nodeSettings = new RemoveBlankPagesNodeSettings();
    private FilePicker fileInput;
    private JSpinner threshold;
    private JCheckBox thresholdEnabled;
    private JTextField whitePercent;
    private JCheckBox whitePercentEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    RemoveBlankPagesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Threshold:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.thresholdEnabled = new JCheckBox();
        this.thresholdEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.thresholdEnabled.setSelected(!this.thresholdEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.thresholdEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.threshold = new JSpinner(new SpinnerNumberModel(RemoveBlankPagesNodeSettings.THRESHOLD_DEFAULT_VALUE, RemoveBlankPagesNodeSettings.THRESHOLD_MINIMUM_VALUE, RemoveBlankPagesNodeSettings.THRESHOLD_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.threshold, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("White Percent:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.whitePercentEnabled = new JCheckBox();
        this.whitePercentEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.whitePercentEnabled.setSelected(!this.whitePercentEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.whitePercentEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.whitePercent = new JTextField(30);
        panel.add((Component)this.whitePercent, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(RemoveBlankPagesNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.threshold.setEnabled(this.thresholdEnabled.isSelected());
        this.whitePercent.setEnabled(this.whitePercentEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.threshold((Integer)this.threshold.getValue());
        this.nodeSettings.thresholdEnabled(this.thresholdEnabled.isSelected());
        this.nodeSettings.whitePercent(this.whitePercent.getText());
        this.nodeSettings.whitePercentEnabled(this.whitePercentEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.threshold.setValue(this.nodeSettings.threshold());
        this.thresholdEnabled.setSelected(this.nodeSettings.thresholdEnabled());
        this.whitePercent.setText(this.nodeSettings.whitePercent());
        this.whitePercentEnabled.setSelected(this.nodeSettings.whitePercentEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

