/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.removeblankpages;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RemoveBlankPagesNodeSettings {
    private static final String FILE_INPUT_KEY = "fileInput";
    private static final String FILE_INPUT_DEFAULT_VALUE = null;
    private String fileInput = FILE_INPUT_DEFAULT_VALUE;
    private static final String THRESHOLD_KEY = "threshold";
    static final Integer THRESHOLD_DEFAULT_VALUE = 10;
    static final Integer THRESHOLD_MINIMUM_VALUE = null;
    static final Integer THRESHOLD_MAXIMUM_VALUE = null;
    private int threshold = THRESHOLD_DEFAULT_VALUE;
    private static final String THRESHOLD_ENABLED_KEY = "thresholdEnabled";
    private boolean thresholdEnabled = false;
    private static final String WHITE_PERCENT_KEY = "whitePercent";
    private static final String WHITE_PERCENT_DEFAULT_VALUE = "99.9";
    private String whitePercent = "99.9";
    private static final String WHITE_PERCENT_ENABLED_KEY = "whitePercentEnabled";
    private boolean whitePercentEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    RemoveBlankPagesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_INPUT_KEY, this.fileInput);
        settings.addInt(THRESHOLD_KEY, this.threshold);
        settings.addBoolean(THRESHOLD_ENABLED_KEY, this.thresholdEnabled);
        settings.addString(WHITE_PERCENT_KEY, this.whitePercent);
        settings.addBoolean(WHITE_PERCENT_ENABLED_KEY, this.whitePercentEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.fileInput = settings.getString(FILE_INPUT_KEY, FILE_INPUT_DEFAULT_VALUE);
        this.threshold = settings.getInt(THRESHOLD_KEY, THRESHOLD_DEFAULT_VALUE.intValue());
        this.thresholdEnabled = settings.getBoolean(THRESHOLD_ENABLED_KEY, false);
        this.whitePercent = settings.getString(WHITE_PERCENT_KEY, WHITE_PERCENT_DEFAULT_VALUE);
        this.whitePercentEnabled = settings.getBoolean(WHITE_PERCENT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String fileInput() {
        return this.fileInput;
    }

    void fileInput(String value) {
        this.fileInput = value;
    }

    int threshold() {
        return this.threshold;
    }

    void threshold(int value) {
        this.threshold = value;
    }

    boolean thresholdEnabled() {
        return this.thresholdEnabled;
    }

    void thresholdEnabled(boolean value) {
        this.thresholdEnabled = value;
    }

    String whitePercent() {
        return this.whitePercent;
    }

    void whitePercent(String value) {
        this.whitePercent = value;
    }

    boolean whitePercentEnabled() {
        return this.whitePercentEnabled;
    }

    void whitePercentEnabled(boolean value) {
        this.whitePercentEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

