/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.sanitizepdf;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.sanitizepdf.SanitizePDFNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class SanitizePDFNodeDialog
extends NodeDialogPane {
    private final SanitizePDFNodeSettings nodeSettings = new SanitizePDFNodeSettings();
    private FilePicker fileInput;
    private JCheckBox removeJavaScript;
    private JCheckBox removeJavaScriptEnabled;
    private JCheckBox removeEmbeddedFiles;
    private JCheckBox removeEmbeddedFilesEnabled;
    private JCheckBox removeXMPMetadata;
    private JCheckBox removeXMPMetadataEnabled;
    private JCheckBox removeMetadata;
    private JCheckBox removeMetadataEnabled;
    private JCheckBox removeLinks;
    private JCheckBox removeLinksEnabled;
    private JCheckBox removeFonts;
    private JCheckBox removeFontsEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    SanitizePDFNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Remove Java Script:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeJavaScriptEnabled = new JCheckBox();
        this.removeJavaScriptEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.removeJavaScriptEnabled.setSelected(!this.removeJavaScriptEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeJavaScriptEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeJavaScript = new JCheckBox("true");
        panel.add((Component)this.removeJavaScript, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Remove Embedded Files:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeEmbeddedFilesEnabled = new JCheckBox();
        this.removeEmbeddedFilesEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.removeEmbeddedFilesEnabled.setSelected(!this.removeEmbeddedFilesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeEmbeddedFilesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeEmbeddedFiles = new JCheckBox("true");
        panel.add((Component)this.removeEmbeddedFiles, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Remove XMP Metadata:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeXMPMetadataEnabled = new JCheckBox();
        this.removeXMPMetadataEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.removeXMPMetadataEnabled.setSelected(!this.removeXMPMetadataEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeXMPMetadataEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeXMPMetadata = new JCheckBox("true");
        panel.add((Component)this.removeXMPMetadata, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Remove Metadata:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeMetadataEnabled = new JCheckBox();
        this.removeMetadataEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.removeMetadataEnabled.setSelected(!this.removeMetadataEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeMetadataEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeMetadata = new JCheckBox("true");
        panel.add((Component)this.removeMetadata, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Remove Links:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeLinksEnabled = new JCheckBox();
        this.removeLinksEnabled.addActionListener(e -> this.updateComponents());
        label5.addActionListener(e -> {
            this.removeLinksEnabled.setSelected(!this.removeLinksEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeLinksEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeLinks = new JCheckBox("true");
        panel.add((Component)this.removeLinks, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label6 = new LabelButton("Remove Fonts:");
        panel.add((Component)label6, c);
        ++c.gridx;
        c.anchor = 17;
        this.removeFontsEnabled = new JCheckBox();
        this.removeFontsEnabled.addActionListener(e -> this.updateComponents());
        label6.addActionListener(e -> {
            this.removeFontsEnabled.setSelected(!this.removeFontsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.removeFontsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.removeFonts = new JCheckBox("true");
        panel.add((Component)this.removeFonts, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(SanitizePDFNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.removeJavaScript.setEnabled(this.removeJavaScriptEnabled.isSelected());
        this.removeEmbeddedFiles.setEnabled(this.removeEmbeddedFilesEnabled.isSelected());
        this.removeXMPMetadata.setEnabled(this.removeXMPMetadataEnabled.isSelected());
        this.removeMetadata.setEnabled(this.removeMetadataEnabled.isSelected());
        this.removeLinks.setEnabled(this.removeLinksEnabled.isSelected());
        this.removeFonts.setEnabled(this.removeFontsEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.removeJavaScript(this.removeJavaScript.isSelected());
        this.nodeSettings.removeJavaScriptEnabled(this.removeJavaScriptEnabled.isSelected());
        this.nodeSettings.removeEmbeddedFiles(this.removeEmbeddedFiles.isSelected());
        this.nodeSettings.removeEmbeddedFilesEnabled(this.removeEmbeddedFilesEnabled.isSelected());
        this.nodeSettings.removeXMPMetadata(this.removeXMPMetadata.isSelected());
        this.nodeSettings.removeXMPMetadataEnabled(this.removeXMPMetadataEnabled.isSelected());
        this.nodeSettings.removeMetadata(this.removeMetadata.isSelected());
        this.nodeSettings.removeMetadataEnabled(this.removeMetadataEnabled.isSelected());
        this.nodeSettings.removeLinks(this.removeLinks.isSelected());
        this.nodeSettings.removeLinksEnabled(this.removeLinksEnabled.isSelected());
        this.nodeSettings.removeFonts(this.removeFonts.isSelected());
        this.nodeSettings.removeFontsEnabled(this.removeFontsEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.removeJavaScript.setSelected(this.nodeSettings.removeJavaScript());
        this.removeJavaScriptEnabled.setSelected(this.nodeSettings.removeJavaScriptEnabled());
        this.removeEmbeddedFiles.setSelected(this.nodeSettings.removeEmbeddedFiles());
        this.removeEmbeddedFilesEnabled.setSelected(this.nodeSettings.removeEmbeddedFilesEnabled());
        this.removeXMPMetadata.setSelected(this.nodeSettings.removeXMPMetadata());
        this.removeXMPMetadataEnabled.setSelected(this.nodeSettings.removeXMPMetadataEnabled());
        this.removeMetadata.setSelected(this.nodeSettings.removeMetadata());
        this.removeMetadataEnabled.setSelected(this.nodeSettings.removeMetadataEnabled());
        this.removeLinks.setSelected(this.nodeSettings.removeLinks());
        this.removeLinksEnabled.setSelected(this.nodeSettings.removeLinksEnabled());
        this.removeFonts.setSelected(this.nodeSettings.removeFonts());
        this.removeFontsEnabled.setSelected(this.nodeSettings.removeFontsEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

