/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.splitpdf1;

import com.nodepit.nodes.stirlingpdf.v1.FilePicker;
import com.nodepit.nodes.stirlingpdf.v1.LabelButton;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.operation.splitpdf1.SplitPdf1NodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class SplitPdf1NodeDialog
extends NodeDialogPane {
    private final SplitPdf1NodeSettings nodeSettings = new SplitPdf1NodeSettings();
    private FilePicker fileInput;
    private JCheckBox includeMetadata;
    private JCheckBox includeMetadataEnabled;
    private JCheckBox allowDuplicates;
    private JCheckBox allowDuplicatesEnabled;
    private JSpinner bookmarkLevel;
    private JCheckBox bookmarkLevelEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    SplitPdf1NodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File Input:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fileInput = new FilePicker();
        panel.add((Component)this.fileInput, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Include Metadata:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.includeMetadataEnabled = new JCheckBox();
        this.includeMetadataEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.includeMetadataEnabled.setSelected(!this.includeMetadataEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.includeMetadataEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.includeMetadata = new JCheckBox("true");
        panel.add((Component)this.includeMetadata, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Allow Duplicates:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.allowDuplicatesEnabled = new JCheckBox();
        this.allowDuplicatesEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.allowDuplicatesEnabled.setSelected(!this.allowDuplicatesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.allowDuplicatesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.allowDuplicates = new JCheckBox("true");
        panel.add((Component)this.allowDuplicates, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Bookmark Level:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.bookmarkLevelEnabled = new JCheckBox();
        this.bookmarkLevelEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.bookmarkLevelEnabled.setSelected(!this.bookmarkLevelEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.bookmarkLevelEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.bookmarkLevel = new JSpinner(new SpinnerNumberModel(SplitPdf1NodeSettings.BOOKMARK_LEVEL_DEFAULT_VALUE, SplitPdf1NodeSettings.BOOKMARK_LEVEL_MINIMUM_VALUE, SplitPdf1NodeSettings.BOOKMARK_LEVEL_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.bookmarkLevel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(SplitPdf1NodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.includeMetadata.setEnabled(this.includeMetadataEnabled.isSelected());
        this.allowDuplicates.setEnabled(this.allowDuplicatesEnabled.isSelected());
        this.bookmarkLevel.setEnabled(this.bookmarkLevelEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.fileInput(this.fileInput.getFile());
        this.nodeSettings.includeMetadata(this.includeMetadata.isSelected());
        this.nodeSettings.includeMetadataEnabled(this.includeMetadataEnabled.isSelected());
        this.nodeSettings.allowDuplicates(this.allowDuplicates.isSelected());
        this.nodeSettings.allowDuplicatesEnabled(this.allowDuplicatesEnabled.isSelected());
        this.nodeSettings.bookmarkLevel((Integer)this.bookmarkLevel.getValue());
        this.nodeSettings.bookmarkLevelEnabled(this.bookmarkLevelEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.fileInput.setFile(this.nodeSettings.fileInput());
        this.includeMetadata.setSelected(this.nodeSettings.includeMetadata());
        this.includeMetadataEnabled.setSelected(this.nodeSettings.includeMetadataEnabled());
        this.allowDuplicates.setSelected(this.nodeSettings.allowDuplicates());
        this.allowDuplicatesEnabled.setSelected(this.nodeSettings.allowDuplicatesEnabled());
        this.bookmarkLevel.setValue(this.nodeSettings.bookmarkLevel());
        this.bookmarkLevelEnabled.setSelected(this.nodeSettings.bookmarkLevelEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

