/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.worldnewsapi.v1.operation.extractnews;

import com.nodepit.nodes.worldnewsapi.v1.ResponseMapper;
import com.nodepit.nodes.worldnewsapi.v1.SimpleResponseMapper;
import com.nodepit.nodes.worldnewsapi.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ExtractNewsNodeSettings {
    private static final String URL_KEY = "url";
    private static final String URL_DEFAULT_VALUE = null;
    private String url = URL_DEFAULT_VALUE;
    private static final String ANALYZE_KEY = "analyze";
    private static final boolean ANALYZE_DEFAULT_VALUE = false;
    private boolean analyze = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"title\":\"rows[0][0]\",\"text\":\"rows[0][1]\",\"url\":\"rows[0][2]\",\"image\":\"rows[0][3]\",\"author\":\"rows[0][4]\",\"language\":\"rows[0][5]\",\"source_country\":\"rows[0][6]\",\"sentiment\":\"rows[0][7]\",\"entities\":\"rows[0][8]\"}}]").addBodyColumn(new DataColumnSpecCreator("Title", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Text", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Image", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Author", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Source Country", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Sentiment", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entities", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ExtractNewsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(URL_KEY, this.url);
        settings.addBoolean(ANALYZE_KEY, this.analyze);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.url = settings.getString(URL_KEY, URL_DEFAULT_VALUE);
        this.analyze = settings.getBoolean(ANALYZE_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.url == null || this.url.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cURL\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String url() {
        return this.url;
    }

    void url(String value) {
        this.url = value;
    }

    boolean analyze() {
        return this.analyze;
    }

    void analyze(boolean value) {
        this.analyze = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

