/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.worldnewsapi.v1.operation.getgeocoordinates;

import com.nodepit.nodes.worldnewsapi.v1.ResponseMapper;
import com.nodepit.nodes.worldnewsapi.v1.SimpleResponseMapper;
import com.nodepit.nodes.worldnewsapi.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetGeoCoordinatesNodeSettings {
    private static final String LOCATION_KEY = "location";
    private static final String LOCATION_DEFAULT_VALUE = null;
    private String location = LOCATION_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"latitude\":\"rows[0][0]\",\"longitude\":\"rows[0][1]\",\"city\":\"rows[0][2]\"}}]").addBodyColumn(new DataColumnSpecCreator("Latitude", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Longitude", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("City", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetGeoCoordinatesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(LOCATION_KEY, this.location);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.location = settings.getString(LOCATION_KEY, LOCATION_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.location == null || this.location.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cLocation\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String location() {
        return this.location;
    }

    void location(String value) {
        this.location = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

